function [xt, yt, x, y] = DataSetSplit( DataSet, TrainingPercent );
%
% split data to training and test parts
% TrainingPercent - % of the training vectors

[N,D] = size(DataSet.Inputs);

rows = randperm(N);				

for i=1:N
   r = rows(i);
   DS.Inputs(i,:) = DataSet.Inputs(r,:);
   DS.Desired(i,:) = DataSet.Desired(r,:);
end
clear rows;

TRAIN_MAX = fix(N*TrainingPercent/100);
xt = DS.Inputs(1:TRAIN_MAX,:);			% training vectors 
yt = DS.Desired(1:TRAIN_MAX, :);
x = DS.Inputs(TRAIN_MAX+1:end, :);		% validation vectors
y = DS.Desired(TRAIN_MAX+1:end, :);