clear
clc

iInput = 4;
iHidden = 6;
iOut = 3;
Nnoisepoints=10;  	% add some noise
VarNoise=0.01;		% with this variance

DS = DataSetLoad('..\data\iris.dat', iInput);

net = rbf(iInput, iHidden, iOut, 'gaussian');
options = foptions;
options(1) = 0;		% Display EM training
%options(14) = 1;	   % number of iterations of EM (default 100)
net.options = options;

[xt, yt] = DataSetSplit(DS, 66);
net = rbftrain(net, net.options, xt, yt);

[DS.Outputs,g,n2] = rbffwd(net,DS.Inputs);
[e, p] = CheckErrors(DS.Outputs, DS.Desired)

PlotNoise(DS, net, Nnoisepoints, VarNoise)

%DataSetPlot(DS, 10);
%DataSetPlotNoise(DS, net, 1, 20);
   
