#ifndef _CMDS_H_
#define _CMDS_H_

#include "matrix.h"
#include "file_class.h"

class CMDS
  {
  private:
  DataFile *MDfile;
  DataFile *OUTfile;

  //okresla czy dane wejsciowe maja byc traktowane jak macierz odleglosci
  bool Dist; 

  unsigned int NumberOfObjects;
  unsigned int NumberOfFeatures;

  bool FullPrecisionEigensystem;
  unsigned int NumberOfIterations;

  inline const double SQR(const double &a)
        {return a*a;}

  //wylicza kwadrat odleglosci dla podanych obiektow
  double Dist2(const Matrix & m, unsigned int i, unsigned int j);
  //mnozy macierz x wektor na wskaznikach
  void MultiplyMxV(const Matrix & M, const Matrix & V, Matrix & MxV);
  void MDdataToB(Matrix & B);
  void DistToB(Matrix & B);
  double EigenSystem(const Matrix & B, double & EVal, Matrix * EVec);
  void cmds();
  double Accuracy();

  public:
  CMDS(DataFile &MDfile, DataFile &OUTfile);
  ~CMDS();
  double ClassicalScaling(bool FullPrecisionEigensystem=true, unsigned int NumberOfIterations=300, bool SquaredDist=false);
  //zwraca wskaznik do podpietego pliku
  DataFile * pMDfile();
  DataFile * pOUTfile();
  };

#endif