% CheckErrorsTest(y_out, y_des ired)
%
% use test data to determine accuracy and confusion matrices
% y_out 		- output from the network
% y_desired 	- desired class labels

nin = 36;			% Number of inputs for Satelite data.
NC=5;			% Number of classes

DS = DataSetLoad('..\data\satim5ta.dat',nin);
disp('Loaded: Satim test data')  
disp([' nin= ' num2str(nin) ' nout = ' num2str(nout)])
Ndat=size(DS.Inputs);
disp([' Input size= ' num2str(Ndat) ]) 

DS.Inputs = Normdata(DS.Inputs);
%
y_out = mlpfwd(net, DS.Inputs);
y_desired=DS.Desired;

[Ndat, NC] = size(y_out);
% N# data points x N classes

Conf=zeros(NC,NC);  % confusion matrix
Confp=Conf;

for i=1:Ndat

[yy id]=max(y_desired(i,:));  % id - desired class
[yy io]=max(y_out(i,:));         % io - obtained class
Conf(id,io)=Conf(id,io)+1; 
Confp(id,:)=Confp(id,:)+y_out(i,:); 

end

% calculate conditional confusion; Sensitivity and Specificity etc
for i=1:NC
s(i)=sum(Conf(i,:));
Confcond(i,:)=Conf(i,:)/s(i);
end

format short; format compact; 
Conf
Confcond
Confp

p = trace(Conf)/Ndat;  % accuracy
e=Ndat-trace(Conf);    % error
disp([' N. err= ' num2str(e) ',  Acc = ' num2str(p)]);
