clear
clc, clf

iInput = 4;
iHidden = 5;
iOut = 5;
alpha = 0.05;
Nnoisepoints=10;  	% add some noise
VarNoise=1.10;		% with this variance

DS = DataSetLoad('..\data\adata_5class.dat',iInput );

net = mlp(iInput, iHidden, iOut, 'logistic', alpha);
options = zeros(1,18);
options(1) = 0;			% This provides display of error values.
options(14) = 30;		% Number of training cycles. 

[xt, yt] = DataSetSplit(DS, 90);
disp([' Train set size= ' num2str(size(xt)) ]) 

[net, options] = netopt(net, options, xt, yt, 'scg');
net.options = options;
disp([' Train epochs= ' num2str(options(14)) ',  Regularization a=' num2str(alpha)]) 

DS.Outputs = mlpfwd(net, DS.Inputs);

[e, p] = CheckErrors(DS.Outputs, DS.Desired);
disp([' N. err= ' num2str(e) ',  Acc = ' num2str(p)])

PlotNoise(DS, net, Nnoisepoints, VarNoise)

%DataSetPlotNoise(DS, net, 1, 12);
%N = 5;
%p = GaussMultiDimPoints( [-100,-100,-100,-100], 0.8, N);
%[y_out] = mlpfwd(net, p);
%[W B] = Projection2D(5);
%y = (W*(y_out)')' + ones(N,1)*B';
%plot(y(:,1), y(:,2), 'ok');



