%  Use NETLAB to create network and do calculations
clear DS DS2; 

nin = 36;			% Number of inputs.
nout = 5;			% Number of outputs.
Nc=5;			% Number of classes left

DS = load('..\data\satim5t.dat');
disp('Loaded data') 
disp([' nin= ' num2str(nin) ' nout = ' num2str(nout)])

Nvec=size(DS);
disp([' Input size= ' num2str(Nvec)]) ;

% Create separate datasets for pairs of classes:  1 & 2

DS2=[];
Out = 	[1 0 0 0 0;
		 0 1 0 0 0;
		 0 0 1 0 0;
		 0 0 0 1 0;
		 0 0 0 0 1];

for i=1:Nvec;
	for c=1:Nc;
		if DS(i,nin+1)==c;
		DS2=[DS2;[DS(i,1:nin) Out(c,:)]];
		end
	end
end

format compact;
format short g;
save 'satim5ta.dat' DS2 -ascii;

Nvec=size(DS2);
disp([' Output size= ' num2str(Nvec)]) ;
