//------------------------------------------------------------------------------
#pragma hdrstop

#if !defined (__mAppH)
    #include "mApp.h"
#endif
//------------------------------------------------------------------------------
#pragma package(smart_init)
//------------------------------------------------------------------------------
//Public
//------------------------------------------------------------------------------
mApp::mApp(const char* x)
    {
    FName=new mString(x);
    mData=new mDane();
    gmal1=0;gmal2=0;
    diskret=0;
    gcechy=0;
    logowanie=false;
    saveGcechy=false;
    itGcechy=true;
    progress=progressMax=0;
    }
//------------------------------------------------------------------------------
mApp::mApp(const mApp& x)
    {
    FName=new mString(*x.FName);
    mData=new mDane(*x.mData);
    gmal1=0;gmal2=0;
    gcechy=0;
    if (x.diskret==0)
        diskret=0;
    else
        {
        diskret=0;
        setDiskret(x.diskret);
        }
    logowanie=x.logowanie;
    saveGcechy=x.saveGcechy;
    itGcechy=x.itGcechy;
    progress=progressMax=0;
    }
//------------------------------------------------------------------------------
mApp::~mApp()
    {
    if (FName)
        {
        delete FName;
        FName=0;
        }
    if (mData)
        {
       delete mData;
       mData=0;
       }
    if (diskret)
        {
        delete[] diskret;
        diskret=0;
        }
    }
//------------------------------------------------------------------------------
void mApp::DataLoad(const char* x)
    {
    /*
    if (mData)
        delete mData;
    mData=new mDane();
    */
    mData->preferences->operation=0;
    try
        {
        mInOut wewy(x,mData,progress,progressMax);
        mData=wewy.returnResult();
        diskret=wewy.readDiskret(mData->preferences->col);
        }
    catch (char* y)
        {
        throw y;
        }
    }
//------------------------------------------------------------------------------
void mApp::ReadFromClip(const char* x,const int y,const bool op1,const int op2)
/*
1 czytany string
2 jego dlugosc
3 jeeli true wstawiamy wiersze w przeciwnym razie wstawiamy kolumny
4 pozycja wstawiania
*/
    {
    char* res=new char[500];
    bool f1=true;
    mString ldat(x,y+10);
    char koniec[3];
    koniec[0]='\r';koniec[1]='\n';koniec[2]='\0';
    int j=0,k=0,x1,x2=0,x3=0;
    int z=ldat.find("\r\n");
    if (z<0)
        {
        z=ldat.find("\n");
        koniec[0]='\n';koniec[1]='\0';koniec[2]='\0';
        }

    if (z>0)
        {
        mString **tab=new mString*[y/z+10];
        tab[0]=new mString[z/2];
        while (f1)
            {
            x1=ldat.find("\t",x2);
            x3=ldat.find(koniec,x3);
            if (x1>x3 || x1==-1)
                {
                if (x3!=-1)
                    {
                    x1=ldat.find(koniec,x3);
                    x3++;
                    }
                if (x1==-1 || x3==-1)
                    f1=false;
                else
                    {
                    x2=ldat.find("\n",x1);
                    x2++;
                    x1=ldat.find("\t",x2);
                    if (x1>0)
                        {
                        k=0;
                        j++;
                        tab[j]=new mString[z/2];
                        }
                    }
                }

            if (f1==true && x1>0)
                {
                ldat.cut(x2,x1-1,res);
                tab[j][k]=res;
                k++;
                x2=x1+1;
                }
            }
        j++;
        mDane nowe(j,k);
        nowe=tab;
        for (int i=0;i<j;i++)
            delete[] tab[i];
        delete[] tab;
        if (op1)
            mData->insertRow(op2,&nowe);
        else
            mData->insertCol(op2,&nowe);
        }
    delete[] res;
    }
//------------------------------------------------------------------------------
void mApp::DataSave(const char* x)
    {
    if (mData!=0)
        {
        mData->preferences->operation=1;
        try
            {
            if (mData->preferences->typeOfmData==3)
                {
                int lcol=mData->preferences->col;
                int *ile=new int [lcol];
                int lklas=mData->preferences->klas;
                if (diskret)
                    {
                    for (int i=0;i<lcol;i++)
                        {
                        if (diskret[i]==false || i==lklas)
                            ile[i]=ileKlas(i);
                        }
                    }
                else
                    {
                    ile[lklas]=ileKlas(lklas);
                    }
                mInOut wewy(x,mData,progress,progressMax,diskret,ile);
                }
            else
                mInOut wewy(x,mData,progress,progressMax,diskret);
            }
        catch (char* y)
            {
            throw y;
            }
        mData->preferences->operation=0;
        }
    else throw ("DataSave brakuje danych ktre by mona zapisa");
    }
//------------------------------------------------------------------------------
void mApp::DeleteData(void)
    {
    if (mData)
        {
        delete mData;
        mData=0;
        }
    else throw ("DeleteData nie moe usun danych");
    }
//------------------------------------------------------------------------------
mDane* mApp::getData(void) const
    {
    if (mData)
        return mData;
    else return 0;
    }
//------------------------------------------------------------------------------
const bool* mApp::getDiskret(void) const
  {
  return this->diskret;
  }
//------------------------------------------------------------------------------
const int mApp::getKlasa(void) const
    {
    return mData->preferences->klas+1;
    }
//------------------------------------------------------------------------------
void mApp::podaj_wc(int &w ,int &c) const
    {
    w=mData->preferences->row;
    c=mData->preferences->col;
    }
//------------------------------------------------------------------------------
int mApp::ile_tab(void) const
    {
    if (mData->wsktest())
      {
      mString dd;
      int max=0;
      for (int i=0;i<mData->preferences->row;i++)
          for (int j=0;j<mData->preferences->col;j++)
              {
              dd=mData->get(i,j);
              if (max<dd.get_len())
                  max=dd.get_len();
              }
      max++;
      return max;
      }
    else
        return 25;
    }
//------------------------------------------------------------------------------
void mApp::set_klasa(const int x)
{
int xx=x-1;
if (xx>=0 && xx<mData->preferences->col)
    {
    if (this->diskret!=0)
        {
        this->diskret[mData->preferences->klas]=this->diskret[xx];
        this->diskret[xx]=1;
        }
    mData->preferences->klas=xx;
    }
else
    mData->preferences->klas=-2;
}
//------------------------------------------------------------------------------
void mApp::setOptions(const mOption& x)
    {
    if (mData->preferences)
        delete mData->preferences;
    mData->preferences=0;
    mData->preferences=new mOption(x);
    }
//------------------------------------------------------------------------------
void mApp::setKlasa(const int x)
{
int xx=x-1;
if (xx>=0 && xx<mData->preferences->col)
    {
    if (this->diskret!=0)
        {
        this->diskret[mData->preferences->klas]=this->diskret[xx];
        this->diskret[xx]=1;
        }
    mData->preferences->klas=xx;
    }
else
    mData->preferences->klas=-2;
}
//------------------------------------------------------------------------------
void mApp::setDiskret(const bool* x)
{
if (this->diskret!=0)
   delete[] this->diskret;
this->diskret=new bool[mData->preferences->col];
for (int i=0;i<mData->preferences->col;i++)
    {
    this->diskret[i]=x[i];
    }
}
//------------------------------------------------------------------------------
void mApp::losuj(const int ile,const int kol,const int liter,const bool opcja)
{
  losuj_dane(ile,kol,liter,opcja);
}
//------------------------------------------------------------------------------
void mApp::obliczaj_p(const int x, const bool opcja)
{

if(mData!=0)
    {
    if (x==0)
        {
        this->obliczaj_p_wektory(opcja);
        }
	else if (x==1)
        {
        this->obliczaj_p_fast(opcja);
        }
	else
        {
        this->obliczaj_p_slow(opcja);
        }
	}
}
//------------------------------------------------------------------------------
void mApp::zamiana_prosta(const int x ,const int start)
{
if (mData){
    numeruj_klasy();
    if (x==0)
        {
        this->zamina_prosta1(start);
        }
    else if (x==1)
        {
        this->zamina_prosta2();
        }
    else if (x==2)
        {
        this->zamina_prosta3();
        }
    else if (x==3)
        {
        this->zamina_prosta4();
        }
    else
        {
        this->zamina_prosta5();
        }
    }
}
//------------------------------------------------------------------------------
void mApp::zamienaj_symbole
(const mString& s1,const mString& s2,const int opcjq,const int kol)
    {
    if (mData!=0)
        {
        mData->zamieniaj_symbol(s1,s2,opcjq,kol);
        }
    }
//-----------------------------------------------------------------------------
void mApp::zamienaj_symbole
(char* s11,char* s22,const int opcjq,const int kol)
    {
    mString s1(s11);
    mString s2(s22);
    if (mData!=0)
        {
        mData->zamieniaj_symbol(s1,s2,opcjq,kol);
        }
    }

//-----------------------------------------------------------------------------
void mApp::standaryzacja(const bool x1,const int x2)
    {
    if (mData!=0)
      {
      int xx=0;
      if (x2>0)
          xx=x2-1;
      if (x1==0)
          {
          if (x2<0)
              {
              if (diskret!=0)
                  {
                  for (int i=0;i<mData->preferences->col;i++)
                      {
                      if (diskret[i]==true)
                          mData->standaryzacja1(i);
                      }
                  }
              else
                  {
                  for (int i=0;i<mData->preferences->col;i++)
                      mData->standaryzacja1(i);
                  }
              }
          else
              {
              mData->standaryzacja1(xx);
              }
          }
      else
          {
           if (x2<0)
              {
              if (diskret!=0)
                  {
                  for (int i=0;i<mData->preferences->col;i++)
                      {
                      if (diskret[i]==true)
                          mData->standaryzacja2(i);
                      }
                  }
              else
                  {
                  for (int i=0;i<mData->preferences->col;i++)
                      mData->standaryzacja2(i);
                  }
              }
          else
              {
              mData->standaryzacja2(xx);
              }
         }
      }
    }
//------------------------------------------------------------------------------
void mApp::DeleteCol(const int x1,const int x2,const bool f1)
    {
	//*******************************
    int xx=x1-1;
    int xxx=x2-1;
    if (f1)
        {
        if (xx<0) xx=0;
        else if (xx>mData->preferences->col) xx=mData->preferences->col-1;
        if (xxx<0) xxx=0;
        else if (xxx>mData->preferences->col) xxx=mData->preferences->col-1;
        if (mData)
            {
            mData->usuwaj_kol(xx,xxx);
            if (this->diskret!=0)
                {
                if (xxx>=xx)
                  {
                  for (int i=xxx;i<mData->preferences->col;i++)
                      this->diskret[i]=this->diskret[i+1-xx];
                  }
                else
                    {
                    for (int i=xx;i<mData->preferences->col;i++)
                        this->diskret[i]=this->diskret[i+1-xxx];
                    }
                }
            }
        }
    else
        {
        if (xx<0) xx=0;
        else if (xx>mData->preferences->row) xx=mData->preferences->row-1;
        if (xxx<0) xxx=0;
        else if (xxx>mData->preferences->row) xxx=mData->preferences->row-1;
        if (mData)
            {
            mData->usuwaj_row(xx,xxx);
            }
        }
	}
//------------------------------------------------------------------------------
void mApp::przestaw_kolumny(const int x,const int y)
    {
	//*******************************
	int dl=mData->preferences->col;
	int xx,yy;
	if (x<=0 || x>dl) xx=0;
	else xx=x-1;
	if (y<=0 || y>dl) yy=dl-1;
	else yy=y-1;
    //*******************************
    if (mData!=0)
        {
        mData->moveRow(xx,yy);
        if (this->diskret!=0)
          {
          bool zap=this->diskret[xx];
          this->diskret[xx]=this->diskret[yy];
          this->diskret[yy]=zap;
          }
        }
	}
//---------------------------------------------------------------------------
void mApp::numeruj_kolumny(const int x, const bool opcja)
    {
    if (x>=0 && x<mData->preferences->col)
        {
        if (opcja==0)
              mData->preferences->klas=x;
        else
            numeruj_klasy(x);
        }
    }
//------------------------------------------------------------------------------
//Private
//------------------------------------------------------------------------------
float* mApp::MakeRandomArr(const int x)
    {
    float* res=new float[x];
    randomize();
    int krok;
    if (x!=0)
        {
        krok=progressMax/3;
        krok=krok/x;
        if (krok==0 || (float)krok/(float)x>=0.5)
            krok++;
        }
    for (int i=0;i<x;i++)
        {
        bool f1=true;
        //*******************************
        progress+=krok;
        //*******************************
        while(f1)
          {
          float store=(float)random(1000);
          store=store/(float)1000;
          res[i]=store;
          if (i>=1) for (int j=0;j<i;j++)
            {
            if (res[j]==store) break;
            if (j+1==i && res[j]!=store) f1=false;
            }
          else f1=false;
          }
        }
    //*******************************
    progress=mData->preferences->row;
    //*******************************
    return res;
    }
//---------------------------------------------------------------------------
  void mApp::numeruj_klasy (const int parametr) const
  {
    mString znak0;
    performBuff **ce;
    int lokalny_parametr;
    //*******************************
    if (parametr==-1)
        lokalny_parametr=mData->preferences->klas;
    else
        lokalny_parametr=parametr;

    try	{
        ce=new performBuff*[1];
        ce[0]=new performBuff[mData->preferences->row];
        }
    catch (std::bad_alloc) {
        throw  "Nie powiodo si utworzenie performBuff'ora";
        }
    //*******************************
    int num=1;
    this->budujcechy1(ce,lokalny_parametr,num);
  for (int i=0;i<mData->preferences->row;i++)
      {
      int j=0;
      int status=1;
      znak0=mData->get(i,lokalny_parametr);
      if (znak0!=(mData->preferences->pytajnik))
        {
        while (znak0!=ce[0][j].co)
            {
            j++;
            if (j>=mData->preferences->row)
                {
                j=0;
                status=0;
                break;
                }
            }
        if(status==1)
            mData->set(ce[0][j].poz,i,lokalny_parametr);
        else
            mData->set("Bd",i,lokalny_parametr);
        }
      }
   delete[] ce[0];
   delete[] ce;
   }
//------------------------------------------------------------------------------
int mApp::ileKlas(const int lx) const {
//*******************************
    performBuff **ce;
    try	{
        ce=new performBuff*[1];
        ce[0]=new performBuff[mData->preferences->row];
        }
    catch (std::bad_alloc) {
        throw  "Nie powiodo si utworzenie performBuff'ora";
        }

    int num=0;
    this->budujcechy1(ce,lx,num);
    delete[] ce[0];
    delete[] ce;
    return num;
   }
//------------------------------------------------------------------------------
void mApp::losuj_dane
		(const int wile_danych,
		const int wdlugosc_wektorow,
		const int wile_liter,
        const bool opcja) {
//*******************************
	 int *liter;
	//*******************************
	try {
	   liter=new int[wdlugosc_wektorow];
	   }
	catch (std::bad_alloc) {
	    throw "Losowanie danych brak ramu";
	    }
   randomize();

   mFormat *xFormat=new mFormat(mData->getFormat());
   if (mData)
        delete mData;
   mData=new mDane(wile_danych,wdlugosc_wektorow);
   mData->setFormat(*xFormat);
   delete xFormat;

  //*******************************
    mData->preferences->row=wile_danych;
    mData->preferences->col=wdlugosc_wektorow;
    progress=0;
    progressMax=mData->preferences->row;
  //*******************************
	for(int i=0;i<wdlugosc_wektorow;i++)
	  {
	  if (opcja==1){
		if(wile_liter>2)
		  liter[i]=random(wile_liter-2)+2;
		else
		  liter[i]=2;
		}
	  else
		liter[i]=wile_liter;
	  }
	 //*******************************
     char znak[2];
     znak[1]='\0';
	 for(int i=0;i<wile_danych;i++)
	    {
       //*******************************
       progress++;
       //*******************************
	    for (int n=0;n<wdlugosc_wektorow;n++)
            {
            int k=random(liter[n]);
            k=k+97;
            znak[0]=(char)k;
            mData->set(znak,i,n);
            }
	    }
	 delete[] liter;
    //*******************************
    if (this->logowanie==1)
        {
        ofstream f2("wylosowane_dane.txt");
        f2<< "\nile_wierszy="<<wile_danych<<" ile_kolumn="<<wdlugosc_wektorow<<"\n";
        for (int i=0;i<wile_danych;i++) {
            for (int ii=0;ii<wdlugosc_wektorow;ii++) {
                 f2 << " ["<<i<<","<<ii<<"] ";
                 f2 << (const char*)mData->get(i,ii)<<" ";
               }
             f2 <<"\n";
            }
         f2.close();
        }
   //*******************************
   progress=mData->preferences->row;
   mData->preferences->klas=mData->preferences->col-1;
   //*******************************
}
//------------------------------------------------------------------------------
void mApp::obliczaj_p_slow
		( const bool opcja1) {
//*******************************
   float cyf;
   //*******************************
   /*
   //Pomiar czasu
   clock_t start, end;
   start = clock();
   */
   //*******************************
   char *str=new char[20];
   int znacznik,znacznik2;
   int wile_danych=mData->preferences->row;
   int dl=mData->preferences->col;
   mString znak,znak0;
   this->numeruj_klasy();
   //*******************************
   progressMax=mData->preferences->row;
   //*******************************
   for(int k=0;k<dl;k++)
	  {
     //*******************************
     progress+=wile_danych/dl;
     //*******************************
	  for(int j=0;j<wile_danych;j++)
	     {
	     znak0=mData->get(j,mData->preferences->klas);
	     znak=mData->get(j,k);
	     znacznik=0;znacznik2=0;
	     if (!opcja1)
		 {
		 for (int m=0;m<wile_danych;m++)
		    {
		    if(znak0==mData->get(m,mData->preferences->klas) && znak==mData->get(m,k))
    			 znacznik++;

		    if(znak0==mData->get(m,mData->preferences->klas))
			  znacznik2++;

		    }
		 }
	     else
             {
	     for (int m=0;m<wile_danych;m++) {
		  if(znak0==mData->get(m,mData->preferences->klas) && znak==mData->get(m,k))
		     znacznik++;

		  if(znak==mData->get(m,k))
			  znacznik2++;

		  }
             }
	     if (k!=mData->preferences->klas)
                  {
		  cyf=((float)znacznik)/((float)znacznik2);
                  gcvt(cyf,5, str);
                  mData->set(str,j,k);
                  }
	  }
      }
   //*******************************
   progress=mData->preferences->row;
   //*******************************
    delete[] str;
   //*******************************
   /*
    ofstream f2("core->txt",ios::app);
    end = clock();
    f2 <<"\nCzas wykonywania obliczan w procedurze wolnej "<<(end - start) / CLK_TCK;
    f2->close();
   */
   //*******************************
 }
//------------------------------------------------------------------------------
void mApp::obliczaj_p_fast(const bool opcja1) {
//*******************************
   bool f1;
   int dll;
   int mal1,mal2;
   int mile_danych=mData->preferences->row;
   int mdl=mData->preferences->col;
   //*******************************
   /*
   //Pomiar czsu
   clock_t start, end;
   start = clock();
   */
   //*******************************
   mString znak,znak0;
   //*******************************
   progressMax=2*(mData->preferences->row);
   //*******************************
   //*******************************
   if (itGcechy)
       {
       this->usun_gcechy();
       gcechy=buduj_macierz_wystapien();
       //*******************************
       if (gstat==false)
          {
          this->usun_gcechy();
          gcechy=buduj_macierz_wystapien(2);
          }
       }
    f1=1;
    dll=0;
    while (f1)
      if (gcechy[0][dll].co=="$") f1=0;
      else dll++;
    mal1=gcechy[0][dll].ile_co;
    mal2=gcechy[0][dll].poz;
    bool h1;
    if (this->diskret==0) h1=0;
    else h1=1;

    if (gstat==true)
    for(int j=0;j<mile_danych;j++)
      {
      //*******************************
      progress++;
      //*******************************
      for (int k=0;k<mdl;k++)
      if (k!=mData->preferences->klas && h1==0)
          {
          int znacznik,znacznik2;
          znak0=mData->get(j,mData->preferences->klas);
          znak=mData->get(j,k);
          //*******************************
          int jj=this->ustal_jj(znak0,gcechy,mal1);
          int kk=this->ustal_kk(znak,gcechy,mal2,jj,k);
          float cyf;
          if (jj>=0 && kk>=0)
              {
              if (opcja1)
                  znacznik2=this->ustal_znacznik2(gcechy,mal1,mal2,jj,kk);
              else
                  znacznik2=gcechy[jj][0].ile_co;

                //*******************************
              znacznik=gcechy[jj][kk].ile_co;
              cyf=((float)znacznik)/((float)znacznik2);
              }
          else
            {
            cyf=0;
            }
          char str[30];
          gcvt(cyf,5, str);
          mData->set(str,j,k);
          }
        else
          {
          if (k!=mData->preferences->klas && this->diskret[k]==0)
              {
              int znacznik,znacznik2;
              znak0=mData->get(j,mData->preferences->klas);
              znak=mData->get(j,k);
              //*******************************
            int jj=this->ustal_jj(znak0,gcechy,mal1);
            int kk=this->ustal_kk(znak,gcechy,mal2,jj,k);
            float cyf;
            if (jj>=0 && kk>=0)
                {
                if (opcja1)
                    znacznik2=this->ustal_znacznik2(gcechy,mal1,mal2,jj,kk);
                else
                    znacznik2=gcechy[jj][0].ile_co;

                  //*******************************
                znacznik=gcechy[jj][kk].ile_co;
                cyf=((float)znacznik)/((float)znacznik2);
                }
            else
              {
              cyf=0;
              }
            char str[30];
            gcvt(cyf,5, str);
            mData->set(str,j,k);
            }
          }
      }
    //*******************************
    this->numeruj_klasy();
    //*******************************
    /*
    ofstream f2("core->txt",ios::app);
    end = clock();
    f2 <<"\nCzas wykonywania obliczan w procedurze szybkiej "<<(end - start) / CLK_TCK;
    f2->close();
   */
   //*******************************
   progress=2*(mData->preferences->row);
   //*******************************
   if (saveGcechy==false)
      this->usun_gcechy();

}
//------------------------------------------------------------------------------
void mApp::obliczaj_p_wektory(const bool opcja)
{

   mString znak;
   if (itGcechy)
       {
       //*******************************
       progressMax=2*(mData->preferences->row);
       //*******************************
       this->usun_gcechy();
       gcechy=this->buduj_macierz_wektorow(opcja);
       }
   else
       {
       //*******************************
       progressMax=mData->preferences->row;
       //*******************************
       }

   bool *h1=new bool[mData->preferences->col];
   int fcol,iklasy,file=0;
   if (this->diskret==0)
        {
        for (int i=0;i<mData->preferences->col;i++)
            h1[i]=0;
        file=1;
        }
   else
        {
        for (int i=0;i<mData->preferences->col;i++)
            {
            h1[i]=diskret[i];
            if (diskret[i]==true)
                file++;
            }
        }

   iklasy=ileKlas(mData->preferences->klas);
   fcol=iklasy*(mData->preferences->col-file)+file;
   skalujDiskret(iklasy,fcol);

   mDane wynik(mData->preferences->row,fcol);
   if (gcechy!=0)
   {
   int k;
   for (int i=0;i<mData->preferences->row;i++)
       {
       //*******************************
       progress++;
       //*******************************
       k=0;
       for (int j=0;j<mData->preferences->col;j++)
            {
            if (mData->preferences->klas!=j && h1[j]==0)
                {
                bool f1=1;
                int l=0;
                znak=mData->get(i,j);
                if (znak!=(mData->preferences->pytajnik))
                    {
                    while(f1)
                        {
                        if (znak==gcechy[j][l].co) break;
                        else if (l>gcechy[0][0].ile_co)
                            {
                            l=-1;
                            break;
                            }
                        else l++;
                        }
                    if (l>=0)
                        {
                        float* wy=gcechy[j][l].coo.toFloat();
                        mString wstaw;
                        for (int g=0;g<iklasy;g++)
                            if (g<wy[0])
                              {
                              wstaw=wy[g+1];
                              wynik.set(wstaw,i,k);
                              k++;
                              }
                            else
                              {
                              wynik.set(-10,i,k);
                              k++;
                              }
                        delete[] wy;
                        }
                    else
                        {
                        wynik.set("Bd w utworzonej tablicy performBuffor",i,k);
                        k++;
                        }

                    }
                else
                  for (int g=0;g<iklasy;g++)
                      {
                      wynik.set(gcechy[mData->preferences->klas][0].coo,i,k);
                      k++;
                      }
                }
            else
                {
                wynik.set(mData->get(i,j),i,k);
                k++;
                }
            }
        }

   mFormat *xFormat=new mFormat(mData->getFormat());
   if (mData)
        delete mData;
   mData=new mDane(wynik);
   mData->setFormat(*xFormat);
   delete xFormat;

   float* fl=(mData->get(0,mData->preferences->col-1)).toFloat();
   if (fl[0]==0)
        numeruj_klasy();
   delete[] fl;
   //*******************************
   progress=progressMax;
   //*******************************
   }
   delete[] h1;
   if (saveGcechy==false)
      this->usun_gcechy();
}
//------------------------------------------------------------------------------
void mApp:: zamina_prosta1
		(const int start)
    {
	int poz='a'-start;
    int dl=mData->preferences->col;
    int ile_danych=mData->preferences->row;
    bool h1;
    if (this->diskret==0) h1=0;
    else h1=1;
   //*******************************
    progressMax=mData->preferences->row;
   //*******************************
	for (int k=0;k<dl;k++)
        {
		//*******************************
        progress+=ile_danych/dl;
	    //*******************************
	     for (int j=0;j<ile_danych;j++)
                 {
                    if (k!=mData->preferences->klas && h1==0)
                        {
                        if (mData->get(j,k)!=mData->preferences->pytajnik)
                            {
                            char znak=((const char*)mData->get(j,k))[0];
                            mData->set((int)(znak-poz),j,k);
                            }
                        else
                            mData->set(mData->preferences->pytajnik,j,k);
                        }
                    else
                        {
                        if (mData->get(j,k)!=mData->preferences->pytajnik)
                            {
                            char znak=((const char*)mData->get(j,k))[0];
                            mData->set((int)(znak-poz),j,k);
                            }
                        else
                            mData->set(mData->preferences->pytajnik,j,k);
                        }
                 }
	 }
   //*******************************
   progress=mData->preferences->row;
   //*******************************
   }
//------------------------------------------------------------------------------
void mApp::zamina_prosta2 (void){
//*******************************
	 int mal1,mal2,ile_danych,dl;
	 mString znak;
     bool h1;
     if (this->diskret==0) h1=0;
     else h1=1;
     //*******************************
     progressMax=2*(mData->preferences->row);
     //*******************************
	 dl=mal1=mData->preferences->col;
	 ile_danych=mal2=mData->preferences->row;
     if (itGcechy)
       {
       this->usun_gcechy();
       gmal1=mal1;
       gmal2=mal2;
       this->utworz_gcechy(mal1,mal2);
     //*******************************
       for (int k=0;k<dl;k++)
          {
          int poo=1;
          //*******************************
          progress+=ile_danych/dl;
          //*******************************
          for (int j=0;j<ile_danych;j++)
              {
              int jj=0;
              znak=mData->get(j,k);
              bool f1=1;
              //*******************************
              while (f1)
                  {
                if (znak==gcechy[k][jj].co)
                    {
                    f1=0;
                    }
                else if(gcechy[k][jj].co=="\0")
                    {
                    gcechy[k][jj].co=znak;
                    gcechy[k][jj].poz=poo;
                    poo++;
                    f1=0;
                    }
                jj++;
                }
              }
          }
       }
	 for (int k=0;k<dl;k++)
        {
		//*******************************
        progress+=ile_danych/dl;
	    //*******************************
	     for (int j=0;j<ile_danych;j++)
            {
            if (k!=mData->preferences->klas && h1==0)
                {
                 int jj=0;
                 znak=mData->get(j,k);
                 if (znak!=(mData->preferences->pytajnik))
                   {
                   bool f11=1;
                   int po=0;
                   while (f11)
                      {
                      if (znak==gcechy[k][jj].co)
                          {
                          po=gcechy[k][jj].poz;
                          f11=0;
                          }
                      jj++;
                      if (jj==gmal2)
                        {
                        jj=-1;
                        break;
                        }
                      }
                  if (jj>=0)
                      mData->set(po,j,k);
                  else
                      mData->set("Zle",j,k);
                  }
                else
                    mData->set(mData->preferences->pytajnik,j,k);
                }
            else if (h1==1)
                {
                 if(this->diskret[k]!=1)
                    {
                     int jj=0;
                     bool f11=1;
                     int po=0;
                     znak=mData->get(j,k);
                     if (znak!=(mData->preferences->pytajnik))
                       {
                       while (f11)
                          {
                          if (znak==gcechy[k][jj].co)
                              {
                              po=gcechy[k][jj].poz;
                              f11=0;
                              }
                          jj++;
                          }
                      mData->set(po,j,k);
                      }
                    else
                        mData->set(mData->preferences->pytajnik,j,k);
                    }
                }
            }
       	//*******************************
	    }
     //*******************************
     progress=2*(mData->preferences->row);
     //*******************************
     if (saveGcechy==false)
         this->usun_gcechy();
	 }
//------------------------------------------------------------------------------
void mApp::zamina_prosta3(void) {
//*******************************
	 int poo;
	 int mal2;
     int mile_danych=mData->preferences->row;
     int mdl=mData->preferences->col;
	 mString znak;
     //*******************************
     progressMax=mData->preferences->row;
     //*******************************
     if (itGcechy)
         {
         this->usun_gcechy();
         performBuff ile_czego=this->zbadaj_ile_ram(1);
         mal2=ile_czego.ile_co*ile_czego.poz;
         this->utworz_gcechy(1,mal2);
         poo=1;
         for (int k=0;k<mdl;k++) {
            this->budujcechy1(gcechy,k,poo);
            }
         }
	 //*******************************
     bool h1;
     if (this->diskret==0) h1=0;
     else h1=1;
	 for (int k=0;k<mdl;k++)
        {
		//*******************************
        progress+=mile_danych/mdl;
	    //*******************************
	    for (int j=0;j<mile_danych;j++)
        {
           if (k!=mData->preferences->klas && h1==0)
               {
               int jj=0;
               znak=mData->get(j,k);
               if (znak!=(mData->preferences->pytajnik))
                 {
                 bool f1=1;
                 int po=0;
                 while (f1){
                    if (znak==gcechy[0][jj].co) {
                            po=gcechy[0][jj].poz;
                            f1=0;
                            }
                    jj++;
                    }
                mData->set(po,j,k);
                }
              else
                mData->set(mData->preferences->pytajnik,j,k);
              }
           else if (h1==1)
                {
                 if(this->diskret[k]!=1)
                    {
                     int jj=0;
                     bool f11=1;
                     int po=0;
                     znak=mData->get(j,k);
                     if (znak!=(mData->preferences->pytajnik))
                       {
                       while (f11)
                          {
                          if (znak==gcechy[0][jj].co)
                              {
                              po=gcechy[0][jj].poz;
                              f11=0;
                              }
                          jj++;
                          }
                      mData->set(po,j,k);
                      }
                    else
                        mData->set(mData->preferences->pytajnik,j,k);
                    }
                }
		  }
	 }
     //*******************************
     progress=mData->preferences->row;
     //*******************************
     if (saveGcechy==false)
         this->usun_gcechy();
	 }
//---------------------------------------------------------------------------
void mApp::zamina_prosta4(void){
//*******************************
   int lrow=mData->preferences->row;
   int lcol=mData->preferences->col;
   //*******************************
   progressMax=2*lrow;
   //*******************************
   budujcechy0();
   //*******************************
   bool *h1=new bool[lcol];
   if (diskret)
      {
      for (int i=0;i<lcol;i++)
          h1[i]=diskret[i];
      h1[mData->preferences->klas]=true;
      }
    else
        {
        for (int i=0;i<lcol;i++)
            h1[i]=false;
        h1[mData->preferences->klas]=true;
        }
    int *ileCzego=new int[lcol];
    for (int i=0;i<lcol;i++)
        {
        if (h1[i]==false)
            ileCzego[i]=ileKlas(i);
        else
            ileCzego[i]=0;
        }
    //*******************************
    int max=0;
    for (int i=0;i<lcol;i++)
        if(ileCzego[i]==0)
            max++;
        else
            max+=ileCzego[i];
   //*******************************
   budujcechy0();
   if (itGcechy)
       gcechy[0][0].ile_co=max;
   else
        {
        if (max<gcechy[0][0].ile_co)
            max=gcechy[0][0].ile_co;
        }
    mDane wynik(lrow,max,"0");
   //*******************************
    progress=lrow;
    //*******************************
    mString znak;
    int jj=0;
    for (int i=0;i<lcol;i++)
      {
      if (h1[i]==false)
        {
        for (int j=0;j<lrow;j++)
            {
            //*******************************
            progress+=lrow/lcol;
            //*******************************
            znak=mData->get(j,i);
            int poz=ustalPozycje(znak,gcechy,gmal2,i);
            if (poz>=0)
              {
              jj+=poz;
              wynik.set("1",j,jj);
              jj-=poz;
              }
            else
                throw "Bad symbol position in zamiana4";
            }
        jj+=ileCzego[i];
        }
      else
          {
          for (int j=0;j<lrow;j++)
              wynik.set(mData->get(j,i),j,jj);
          jj++;
          }
      }
 //*******************************
 progress=2*lrow;
 //*******************************
  if (saveGcechy==false)
     this->usun_gcechy();
 delete[] h1;
 delete[] ileCzego;

 mFormat *xFormat=new mFormat(mData->getFormat());
 if (mData)
      delete mData;
 mData=new mDane(wynik);
 mData->setFormat(*xFormat);
 delete xFormat;

 }
//---------------------------------------------------------------------------
void mApp::zamina_prosta5 (void) {
//*******************************
     int ile_danych;
     int dl;
	 mString znak;
     bool h1;
     if (this->diskret==0) h1=false;
     else h1=true;
	 dl=mData->preferences->col;
	 ile_danych=mData->preferences->row;
     if (itGcechy)
         {
         //*******************************
         progressMax=3*(mData->preferences->row);
         //*******************************
         int xworth=0,xile=(zbadaj_ile_ram(1).poz);
         float *worth=MakeRandomArr(xile);
         this->usun_gcechy();
         this->utworz_gcechy(dl,ile_danych);
         for (int k=0;k<dl;k++)
              {
              int poo=1;
              //*******************************
              progress+=ile_danych/dl;
              //*******************************
              for (int j=0;j<ile_danych;j++)
                  {
                  int jj=0;
                  znak=mData->get(j,k);
                  bool f1=true;
                  while (f1) {
                    if (znak==gcechy[k][jj].co) f1=false;
                    else if(gcechy[k][jj].co=="\0")
                        {
                        gcechy[k][jj].co=znak;
                        gcechy[k][jj].coo=worth[xworth];
                        gcechy[k][jj].poz=poo;
                        poo++;
                        xworth++;
                        if (xworth==xile)
                            throw "Zamiana5: wyjcie poza przydzielon pami worth";
                        f1=false;
                        }
                    jj++;
                    if (jj==ile_danych)
                        throw "Zamiana5: wyjcie poza przydzielon pami gcech";
                    }
                  }
              }
         delete[] worth;
         progress=2*(mData->preferences->row);
         }
     else
        {
         //*******************************
         progressMax=mData->preferences->row;
         //*******************************
        }
	 for (int k=0;k<dl;k++)
        {
		//*******************************
		progress+=ile_danych/dl;
	    //*******************************
	     for (int j=0;j<ile_danych;j++)
            {
            if (k!=mData->preferences->klas && h1==false)
                {
                 int jj=0;
                 znak=mData->get(j,k);
                 if (znak!=(mData->preferences->pytajnik))
                   {
                   bool f11=true;
                   while (f11)
                      {
                      if (znak==gcechy[k][jj].co)
                          f11=false;
                      jj++;
                      if (jj==gmal2)
                        {
                        jj=-1;
                        break;
                        }
                      }
                  if (jj>=0)
                      mData->set(gcechy[k][jj-1].coo,j,k);
                  else
                      mData->set("Zle",j,k);
                  }
                /*
                else
                    mData->set(*mData->pytajnik,j,k);
                */
                }
            else if (h1==true)
                {
                 if(this->diskret[k]!=1)
                    {
                     int jj=0;
                     bool f11=true;
                     znak=mData->get(j,k);
                     if (znak!=(mData->preferences->pytajnik))
                       {
                       while (f11)
                          {
                          if (znak==gcechy[k][jj].co)
                              f11=false;
                          jj++;
                          if (jj==gmal2)
                            {
                            jj=-1;
                            break;
                            }
                          }
                      if (jj>=0)
                          mData->set(gcechy[k][jj-1].coo,j,k);
                      else
                         mData->set("Zle",j,k);
                      }
                    /*
                    else
                        mData->set(*mData->pytajnik,j,k);
                    */
                    }
                }
            }
       	//*******************************
	    }
     //*******************************
     progress=progressMax;
     //*******************************
     if (saveGcechy==false)
         this->usun_gcechy();
	 }
//------------------------------------------------------------------------------
performBuff** mApp::buduj_macierz_wystapien (const int upp){
//*******************************
    mString znak,znak0;
    int dll,mal1=0,mal2=0;
    int wile_danych=mData->preferences->row;
    int dl=mData->preferences->col;
    performBuff **cechy,ce;
    gstat=true;
   //*******************************
   ce=zbadaj_ile_ram(upp);
   mal1=ce.ile_co;
   mal2=ce.poz;
   gmal1=mal1;
   gmal2=mal2;
  try
    {
	cechy=new performBuff*[mal1];
	for (int i=0;i<mal1;i++)
		cechy[i]=new performBuff[mal2];
	}
  catch (std::bad_alloc)
    {
	throw  "Nie powiodo si utworzenie performBuff'ora";
	}


   for (int kk=0;kk<10;kk++)
     {
     for(int j=0;j<wile_danych;j++)
        {
        int jj=0;
        //*******************************
        progress++;
        //*******************************
        znak0=mData->get(j,mData->preferences->klas);
        bool f0=true;
        //*******************************
        while (f0) {
          if (znak0==cechy[jj][0].co) {
              cechy[jj][0].ile_co=cechy[jj][0].ile_co+1;
              f0=false;
              }
          else if (cechy[jj][0].co=="\0") {
              cechy[jj][0].co=znak0;
              cechy[jj][0].ile_co=1;
              cechy[jj][0].poz=mData->preferences->klas;
              f0=false;
              }
          else if (f0!=false && jj+1>=mal1)
              gstat=false;

          jj++;
          if (jj==mal1+1)
            throw "Wyjcie poza zakres pierwsz skadow w procedurze obliczania macierzy wystpie";
          }
        jj--;
        //*******************************
        for (int k=0;k<dl;k++)
          {
          int k2=1;
          znak=mData->get(j,k);
          bool f1=true;
          //*******************************
          while (f1 && k!=mData->preferences->klas)
            {
                if (znak==cechy[jj][k2].co && cechy[jj][k2].poz==k)
                    {
                    cechy[jj][k2].ile_co+=1;
                    f1=false;
                    }
                else if (cechy[jj][k2].co=="\0")
                    {
                    cechy[jj][k2].co=znak;
                    cechy[jj][k2].ile_co=1;
                    cechy[jj][k2].poz=k;
                    f1=false;
                    }
                else if (f1!=false && k2+1>=mal2)
                  gstat=false;
                k2++;
                if (k2==mal2+1)
                    throw "Wyjcie poza zakres drug skadow w procedurze obliczania macierzy wystpie";
            }
          //*******************************
          }
       }
      if (gstat==1) break;
      else
        {
        for (int i=0;i<mal1;i++)
            delete cechy[i];
        delete cechy;
        mal2=mal2+20;
        try
          {
          cechy=new performBuff*[mal1];
          for (int i=0;i<mal1;i++)
              cechy[i]=new performBuff[mal2];
          }
        catch (std::bad_alloc)
            {
            throw  "Nie powiodo si utworzenie performBuff'ora";
            }
        }
      }
    bool f1=true;
    dll=0;
    while (f1) {
      if (cechy[0][dll].co=="\0") f1=0;
      else if (dll+1>=mal2) {
          gstat=false;
          f1=false;
          }
      else dll++;
      }
    cechy[0][dll].co="$";
    if (gstat==true) {
    	cechy[0][dll].ile_co=mal1;
    	cechy[0][dll].poz=mal2;
    	}
    else {
    	cechy[0][dll].ile_co=-1;
    	cechy[0][dll].poz=-1;
        gstat=false;
    	}
    //*******************************
    if (this->logowanie==true)
        {
        ofstream f2("macierz_wystepowania1.txt",ios::app);
        if (gstat==true)
            f2<<"Struktura macierzy dobra, nie uszkodzona";
        else
            f2<<"Struktura macierzy za, uszkodzona";
        f2<< "\nklasy="<<mal1<<" zawartosc="<<mal2<<"\n";
        for (int i=0;i<mal1;i++)
            for (int ii=0;ii<mal2;ii++) {
                 f2 << " ["<<i<<","<<ii<<"]\tco= ";
                 f2 << (const char*)cechy[i][ii].co<<" ";
                 f2 <<" ile_razy= " <<cechy[i][ii].ile_co<<" ";
                 f2 <<" pozycja= "<<cechy[i][ii].poz<<"\n";
               }
         f2<<"\n";
         f2.close();
        }
	//*******************************
	return cechy;
	}
//------------------------------------------------------------------------------
performBuff** mApp::buduj_macierz_wektorow (const bool opcja)
{
   performBuff **cechy,**wynik;
   mFormat pliku=mData->getFormat();
   int mile_danych=mData->preferences->row;
   int mdl=mData->preferences->col;
   int mal1,mal2,k1;

   cechy=buduj_macierz_wystapien();
   if (gstat==false)
        {
        for (int i=0;i<gmal1;i++)
            delete[] cechy[i];
        delete[] cechy;
        cechy=buduj_macierz_wystapien(2);
        }
   mal1=gmal1;
   mal2=gmal2;

    try	{
	    wynik=new performBuff*[mdl];
	    for (int i=0;i<mdl;i++)
		    wynik[i]=new performBuff[mal2];
	    }
    catch (std::bad_alloc) {
        throw  "Nie powiodo si utworzenie performBuff'ora";
        }
gmal1=mdl;
gmal2=mal2;
//*******************************
/*
bool h1;
if (this->diskret==0) h1=0;
else h1=1;
*/
bool *h1=new bool[mData->preferences->col];
if (this->diskret==0)
    {
    for (int i=0;i<mData->preferences->col;i++)
        h1[i]=0;
    }
else
    {
    for (int i=0;i<mData->preferences->col;i++)
        h1[i]=diskret[i];
    }

mString znak,znak0;
for (int k=0;k<mdl;k++)
   {
   //*******************************
   progress+=mile_danych/mdl;
   //*******************************
   for(int j=0;j<mile_danych;j++)
      {
      mString znak=mData->get(j,k);
       k1=0;
       bool f1=1;
       while(f1)
          {
          if (wynik[k][k1].coo=="\0") break;
          else if (znak==wynik[k][k1].co)
              {
              f1=0;
              break;
              }
          else k1++;
          }
       if (k!=mData->preferences->klas && f1==1 && h1[k]==false)
          {
           if (k1<mal2)
              {
              wynik[k][k1].poz=k;
              wynik[k][k1].co=znak;
              }
           for (int ni=0;ni<mal1;ni++) //for (int ni=0;ni<mal1-1;ni++) jeeli mamy opuszczc 1 prawdopodobiestwo
              {
              float cyf ;
              int kk,jj;
              int znacznik,znacznik2;
              mString znak0=cechy[ni][0].co;
              //*******************************
              jj=this->ustal_jj(znak0,cechy,mal1);
              kk=this->ustal_kk(znak,cechy,mal2,jj,k);
              //*******************************
              if (jj<0 || kk<0)
                  cyf=0;
              else
                  {
                  if (opcja==1)
                      {
                      znacznik2=this->ustal_znacznik2(cechy,mal1,mal2,jj,kk);
                      znacznik=cechy[jj][kk].ile_co;
                      }
                  else
                      {
                      znacznik=cechy[jj][kk].ile_co;
                      znacznik2=cechy[jj][0].ile_co;
                      }
                  //*******************************
                  if (znacznik2!=0)
                      cyf=((float)znacznik)/((float)znacznik2);
                  else
                      cyf=0;
                  }
              //*******************************
              char str[30];
              gcvt(cyf,5, str);
              if (k1<mal2)
                  {
                  wynik[k][k1].coo=wynik[k][k1].coo+str;
                  if (ni+1!=mal1)
                      wynik[k][k1].coo=wynik[k][k1].coo+pliku.getSpace();
                  }
           }
          //*******************************
          }
       else
          {
          if (f1!=0 && k1<mal2)
              {
              wynik[k][k1].poz=k;
              wynik[k][k1].co=znak;
              wynik[k][k1].coo=znak;
              }
          }
     }
//*******************************
   }
//*******************************
for (int i=0;i<mal1;i++)
    delete[] cechy[i];
delete[] cechy;
delete[] h1;
//*******************************
wynik[0][0].ile_co=mal2;
wynik[mData->preferences->klas][0].coo=mData->preferences->pytajnik;
wynik[mData->preferences->klas][1].coo="1";
/*
for (int i=0;i<mal1-1;i++)
    {
    wynik[mData->preferences->klas][0].coo=wynik[mData->preferences->klas][0].coo+pliku.getSpace();
    wynik[mData->preferences->klas][0].coo=wynik[mData->preferences->klas][0].coo+mData->preferences->pytajnik;
    wynik[mData->preferences->klas][1].coo=wynik[mData->preferences->klas][1].coo+pliku.getSpace();
    wynik[mData->preferences->klas][1].coo=wynik[mData->preferences->klas][1].coo+"1";
    }
*/
//*******************************
    if (this->logowanie==1)
        {
        ofstream f2("macierz_wystepowania2.txt");
        f2<< "\nkolumny="<<mdl<<" zawartosc="<<mal2<<"\n";
        for (int i=0;i<mdl;i++)
            for (int ii=0;ii<mal2;ii++)
               {
                 f2 << " ["<<i<<","<<ii<<"] ";
                 f2 <<"co= "<<(const char*)wynik[i][ii].co<<" ";
                 f2 <<"prawdopodobienstwa= "<<(const char*)wynik[i][ii].coo<<" ";
                 f2 <<"kolumna= "<<wynik[i][ii].poz<<"\n";
               }
         f2.close();
         }
return wynik;
}
//---------------------------------------------------------------------------
performBuff mApp::zbadaj_ile_ram(const int upp) const {
//*******************************
    mString znak0;
    performBuff **ce,wynik;
    try	{
        ce=new performBuff*[1];
        ce[0]=new performBuff[mData->preferences->row+1];
        }
    catch (std::bad_alloc)
        {
        throw  "Nie powiodo si utworzenie performBuff'ora";
        }
    //*******************************
    wynik.poz=0;
    int suma=0;
    for (int k=0;k<mData->preferences->col;k++)
        {
        int pozycje=0;
        this->budujcechy1(ce,k,pozycje);
        suma+=(pozycje++);
        if (k==mData->preferences->klas)
            wynik.ile_co=pozycje-1;
        for(int j=0;j<pozycje;j++)
            ce[0][j].co="\0";
        }
   wynik.co="$";
   wynik.poz=suma;
   wynik.poz=wynik.poz*upp+1;
   delete[] ce[0];
   delete[] ce;
   return wynik;
   }
//------------------------------------------------------------------------------
int mApp::ustal_jj(const mString& znak0,performBuff** cechy,const int mal1)const
{
        bool f1=1;
        int jk=0;
        while(f1)
          {
          if (znak0==cechy[jk][0].co) f1=0;
          else if (jk+1>=mal1)
              {
              jk=-1;
              break;
              }
          else jk++;
          }
   return jk;
}
//------------------------------------------------------------------------------
int mApp::ustal_kk
(const mString& znak,performBuff** cechy,const int mal2,const int jj,const int k)const
{
  int kk=0;
  bool f1=1;
  while(f1) {
    if (znak==cechy[jj][kk].co && k==cechy[jj][kk].poz)
        f1=0;
    else if (kk+1>=mal2)
        {
        kk=-1;
        break;
        }
    else kk++;
    }
return kk;
}
//-----------------------------------------------------------------------------
int mApp::ustalPozycje
(const mString& znak,performBuff** cechy,const int mal2,const int poz) const
    {
    for (int i=0;i<mal2;i++)
        {
        if (znak==cechy[poz][i].co)
            return cechy[poz][i].poz;
        }
    return -1;
    }
//-----------------------------------------------------------------------------
int mApp::ustal_znacznik2
(performBuff** cechy,const int mal1,const int mal2,const int jj,const int kk)const
{
int znacznik2=0;
mString pusty;
for (int i=0;i<mal1;i++)
    {
    int l=0;
    bool f1=1;
    while (f1)
      {
      if (cechy[i][l].co==cechy[jj][kk].co &&
              cechy[i][l].poz==cechy[jj][kk].poz)
              {
              znacznik2+=cechy[i][l].ile_co;
              f1=0;
              }
      else if (cechy[i][l].co==pusty || l+1 >=mal2)
            f1=0;
      else l++;
      }
    }
return znacznik2;
}
//-----------------------------------------------------------------------------
void mApp::usun_gcechy(void)
    {
    if (gcechy)
      {
      for (int i=0;i<gmal1;i++)
            delete[] gcechy[i];
      delete[] gcechy;
      }
    gmal1=0;
    gmal2=0;
    gcechy=0;
    }
//-----------------------------------------------------------------------------
void mApp::utworz_gcechy(const int x,const int y)
    {
    gmal1=x;
    gmal2=y;
    if (x==0) throw "Zerowy rozmiar performBuff`a";
    else try
        {
        gcechy=new performBuff*[gmal1];
	    for (int i=0;i<gmal1;i++)
		    gcechy[i]=new performBuff[gmal2];
	    }
    catch (std::bad_alloc) {
        throw  "Nie powiodo si utworzenie performBuff'ora";
        }

    }
//-----------------------------------------------------------------------------
void mApp::budujcechy0(void)
    {
    mString znak;
    int lcol=mData->preferences->col;
    int lrow=mData->preferences->row;
    if (itGcechy)
        {
        usun_gcechy();
        utworz_gcechy(lcol,lrow);
        }
    for (int i=0;i<lcol;i++)
    for (int j=0;j<lrow;j++)
        {
        //*******************************
        progress+=lrow/lcol;
        //*******************************
        znak=mData->get(j,i);
        bool f1=true;
        int jj=0;
        //*******************************
        while (f1)
            {
            if (znak==gcechy[i][jj].co)
                {
                if (itGcechy)
                    gcechy[i][jj].ile_co++;
                f1=false;
                }
            if (gcechy[i][jj].co=="\0")
                {
                gcechy[i][jj].co=znak;
                gcechy[i][jj].ile_co=1;
                gcechy[i][jj].poz=jj;
                f1=false;
                }
            jj++;
            }
        }
    }
//-----------------------------------------------------------------------------
void mApp::budujcechy1(performBuff** cechy,const int k,int& poo) const
    {
    mString znak;
    for (int j=0;j<mData->preferences->row;j++)
        {
        int jj=0;
        znak=mData->get(j,k);
        bool f1=true;
        //*******************************
        while (f1)
            {
            if (znak==cechy[0][jj].co)
                {
                cechy[0][jj].ile_co++;
                f1=false;
                }
            if (cechy[0][jj].co=="\0")
                {
                cechy[0][jj].co=znak;
                cechy[0][jj].ile_co=1;
                cechy[0][jj].poz=poo;
                poo++;
                f1=false;
                }
            jj++;
            }
        }
    }
//------------------------------------------------------------------------------
void mApp::skalujDiskret(const int ileKlas,const int newCol)
    {
    if (diskret!=0)
        {
        //int ileCont=0;
        bool* wynik=new bool[newCol];
        /*
        for (int i=0;i<mData->preferences->col;i++)
            if (diskret[i]==true)
                ileCont++;
        */
        int k=0;
        for (int i=0;i<mData->preferences->col;i++)
            {
            if (diskret[i]==false)
                for (int j=0;j<ileKlas;j++)
                    {
                    wynik[k]=false;
                    k++;
                    }
            else
                {
                wynik[k]=true;
                k++;
                }
            }
        delete[] diskret;
        diskret=wynik;
        }
    }
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
statystyka::statystyka(const mApp& x): mApp(x)
    {
    klasy=ileKlas(mData->preferences->klas);
    info=new float*[klasy];
    pola=(mData->preferences->col-1)+5;
    for (int i=0;i<klasy;i++)
        info[i]=new float[pola];
    gcechy=buduj_macierz_wystapien();
    if(mApp::gcechy)
        {
        analiza0();
        }
    else
        pola=-1;
    }
//------------------------------------------------------------------------------
statystyka::~statystyka(void)
    {
    usun_gcechy();
    for (int i=0;i<klasy;i++)
        delete[] info[i];
    delete[] info;
    }
//------------------------------------------------------------------------------
void statystyka::analiza0(void)
    {
    for (int i=0;i<mApp::gmal1;i++)
        {
        info[i][0]=(float)gcechy[i][0].ile_co;
        info[i][1]=0;
        for (int j=1;j<pola;j++)
            info[i][j]=0;
        for(int j=0;j<mApp::gmal2;j++)
            {

            if (gcechy[i][j].co==mData->preferences->pytajnik)
                info[i][1]+=(float)gcechy[i][j].ile_co;

            if (gcechy[i][j].ile_co!=0 && gcechy[i][j].poz<gmal2)
                info[i][gcechy[i][j].poz+4]++;
            else
                break;
            }
        }
    }
//------------------------------------------------------------------------------
void statystyka::analiza2(const int x)
    {

    for (int i=0;i<klasy;i++)
        {
        info[i][2]=0;
        int xile=0;
        for(int j=0;j<mApp::gmal2;j++)
            {
            if (gcechy[i][j].ile_co==0)
                break;
            if (gcechy[i][j].ile_co!=0 && gcechy[i][j].poz==x)
                {
                float* xy=gcechy[i][j].co.toFloat();
                if (xy[0]>0)
                    {
                    xile+=gcechy[i][j].ile_co;
                    info[i][2]+=xy[1]*(float)gcechy[i][j].ile_co;
                    delete[] xy;
                    }
                else
                    {
                    info[i][2]=-100;
                    delete[] xy;
                    break;
                    }
                }
            }
        if (info[i][2]!=-100)
            info[i][2]=info[i][2]/(float)(xile);
        }

    for (int i=0;i<klasy;i++)
        {
        int xile=0;
        info[i][3]=0;
        if (info[i][2]!=-100) for(int j=0;j<mApp::gmal2;j++)
            {
            if (gcechy[i][j].ile_co==0)
                break;
            if (gcechy[i][j].ile_co!=0 && gcechy[i][j].poz==x)
                {
                float* xy=gcechy[i][j].co.toFloat();
                if (xy[0]>0)
                    {
                    xile+=gcechy[i][j].ile_co;
                    info[i][3]+=((info[i][2]-xy[1])*(info[i][2]-xy[1]))*(float)gcechy[i][j].ile_co;
                    delete[] xy;
                    }
                else
                    {
                    info[i][3]=-100;
                    delete[] xy;
                    break;
                    }
                }
            }
        else
            info[i][3]=-100;

        if (info[i][3]!=-100)
            info[i][3]=info[i][3]/(float)(xile-1);
        }
    }
//------------------------------------------------------------------------------
int** statystyka::analizaCol(const int x)
    {
    analiza2(x);
    int** wynik;
    wynik=new int *[klasy];
    for(int i=0;i<klasy;i++)
        wynik[i]=new int[mData->preferences->row+1];

    for (int i=0;i<klasy;i++)
        {
        wynik[i][0]=0;
        for(int j=0;j<mApp::gmal2;j++)
            {
            if (gcechy[i][j].ile_co==0)
                break;
            if (gcechy[i][j].ile_co!=0 && gcechy[i][j].poz==x)
                {
                wynik[i][0]++;
                wynik[i][wynik[i][0]]=gcechy[i][j].ile_co;
                }
            }
        }

    return wynik;
    }

//------------------------------------------------------------------------------
