%  Use NETLAB to create network and do calculations
clear
clc;clf

nin = 21;			% Number of inputs.
nout = 2;			% Number of outputs.

nhidden = 30;		% Number of hidden units.
alpha     = 0.05;	% Coefficient of weight-decay prior. 

Nnoisepoints=12;  	% add some noise
VarNoise=0.01;	% with this variance

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

DS = DataSetLoad('..\data\thyrc12.dat',nin);
disp('Loaded: Thyroid data')  
disp([' nin= ' num2str(nin) ' nout = ' num2str(nout)])
disp([' Input size= ' num2str(size(DS.Inputs)) ]) 

DS.Inputs = Normdata(DS.Inputs);
%			
net = mlp(nin, nhidden, nout, 'logistic', alpha);
options = zeros(1,18);
options(1) = 1;				% This provides display of error values.
options(14) = 500	;		% Number of training cycles. 

%	Split data to train and test - but test on all? 
[xt, yt] = DataSetSplit(DS, 100);
disp([' Train set size= ' num2str(size(xt)) ]) 

%  Optimize network, on train data [xt, yt], with SCG method
disp([' Train epochs= ' num2str(options(14)) ',  Regularization a=' num2str(alpha)]) 

%[net, options] = netopt(net, options, xt, yt, 'conjgrad');
[net, options] = netopt(net, options, xt, yt, 'scg');
net.options = options;

DS.Outputs = mlpfwd(net, DS.Inputs);

[e, p] = CheckErrors(DS.Outputs, DS.Desired);

% Plot data and noise, define marker sizes and colors
PlotNoise(DS, net, Nnoisepoints, VarNoise)
