// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AdvGrid.pas' rev: 5.00

#ifndef AdvGridHPP
#define AdvGridHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Mask.hpp>	// Pascal unit
#include <ImgList.hpp>	// Pascal unit
#include <WinSpool.hpp>	// Pascal unit
#include <ComObj.hpp>	// Pascal unit
#include <ShellAPI.hpp>	// Pascal unit
#include <OleCtnrs.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <Commctrl.hpp>	// Pascal unit
#include <RichEdit.hpp>	// Pascal unit
#include <AdvCombo.hpp>	// Pascal unit
#include <AdvObj.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <ASGEdit.hpp>	// Pascal unit
#include <asgspin.hpp>	// Pascal unit
#include <IniFiles.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <AdvUtil.hpp>	// Pascal unit
#include <Buttons.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Printers.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Clipbrd.hpp>	// Pascal unit
#include <Grids.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Advgrid
{
//-- type declarations -------------------------------------------------------
typedef bool tboolarray[257];

typedef bool *pboolarray;

typedef short twidtharray[257];

class DELPHICLASS EAdvGridError;
class PASCALIMPLEMENTATION EAdvGridError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EAdvGridError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EAdvGridError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EAdvGridError(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EAdvGridError(int Ident, const System::TVarRec * Args
		, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EAdvGridError(const AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EAdvGridError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EAdvGridError(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EAdvGridError(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EAdvGridError(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TEditorType { edNormal, edSpinEdit, edComboEdit, edComboList, edEditBtn, edCheckBox, edDateEdit, 
	edDateEditUpDown, edTimeEdit, edButton, edDataCheckBox, edNumeric, edPositiveNumeric, edFloat, edCapital, 
	edMixedCase, edPassword, edUnitEditBtn, edLowerCase, edUpperCase, edFloatSpinEdit, edTimeSpinEdit, 
	edDateSpinEdit, edNumericEditBtn, edFloatEditBtn, edCustom };
#pragma option pop

typedef void __fastcall (__closure *TGetEditorTypeEvent)(System::TObject* Sender, int aCol, int aRow
	, TEditorType &aEditor);

typedef void __fastcall (__closure *TEllipsClickEvent)(System::TObject* Sender, int aCol, int aRow, 
	AnsiString &S);

typedef void __fastcall (__closure *TButtonClickEvent)(System::TObject* Sender, int aCol, int aRow);
	

typedef void __fastcall (__closure *TCheckBoxClickEvent)(System::TObject* Sender, int aCol, int aRow
	, bool state);

typedef void __fastcall (__closure *TRadioClickEvent)(System::TObject* Sender, int aCol, int aRow, int 
	aIdx);

typedef void __fastcall (__closure *TComboChangeEvent)(System::TObject* Sender, int aCol, int aRow, 
	int aItemIndex, AnsiString aSelection);

typedef void __fastcall (__closure *TSpinClickEvent)(System::TObject* Sender, int aCol, int aRow, int 
	aValue, bool updown);

typedef void __fastcall (__closure *TFloatSpinClickEvent)(System::TObject* Sender, int aCol, int aRow
	, double aValue, bool updown);

typedef void __fastcall (__closure *TDateTimeSpinClickEvent)(System::TObject* Sender, int aCol, int 
	aRow, System::TDateTime aValue, bool updown);

#pragma option push -b-
enum TScrollHintType { shNone, shVertical, shHorizontal, shBoth };
#pragma option pop

#pragma option push -b-
enum TSortStyle { ssAutomatic, ssAlphabetic, ssNumeric, ssDate, ssAlphaNoCase, ssAlphaCase, ssShortDateEU, 
	ssShortDateUS, ssCustom, ssFinancial, ssAnsiAlphaCase, ssAnsiAlphaNoCase, ssRaw, ssHTML, ssImages }
	;
#pragma option pop

#pragma option push -b-
enum TPrintPosition { ppNone, ppTopLeft, ppTopRight, ppTopCenter, ppBottomLeft, ppBottomRight, ppBottomCenter 
	};
#pragma option pop

#pragma option push -b-
enum TPrintBorders { pbNoborder, pbSingle, pbDouble, pbVertical, pbHorizontal, pbAround, pbAroundVertical, 
	pbAroundHorizontal, pbCustom };
#pragma option pop

#pragma option push -b-
enum TCellBorder { cbTop, cbLeft, cbRight, cbBottom };
#pragma option pop

typedef Set<TCellBorder, cbTop, cbBottom>  TCellBorders;

#pragma option push -b-
enum TPrintMethod { prPreview, prPrint, prCalcPrint, prCalcPreview };
#pragma option pop

#pragma option push -b-
enum TSortDirection { sdAscending, sdDescending };
#pragma option pop

#pragma option push -b-
enum TAdvanceDirection { adLeftRight, adTopBottom };
#pragma option pop

#pragma option push -b-
enum TIntelliPan { ipVertical, ipHorizontal, ipBoth, ipNone };
#pragma option pop

#pragma option push -b-
enum TInsertPosition { pInsertBefore, pInsertAfter };
#pragma option pop

#pragma option push -b-
enum TScrollType { ssNormal, ssFlat, ssEncarta };
#pragma option pop

#pragma option push -b-
enum TVAlignment { vtaCenter, vtaTop, vtaBottom };
#pragma option pop

typedef void __fastcall (__closure *TCanInsertRowEvent)(System::TObject* Sender, int ARow, bool &CanInsert
	);

typedef void __fastcall (__closure *TAutoInsertRowEvent)(System::TObject* Sender, int ARow);

typedef void __fastcall (__closure *TCanAddRowEvent)(System::TObject* Sender, bool &CanAdd);

typedef void __fastcall (__closure *TAutoAddRowEvent)(System::TObject* Sender, int ARow);

typedef void __fastcall (__closure *TCanDeleteRowEvent)(System::TObject* Sender, int ARow, bool &CanDelete
	);

typedef void __fastcall (__closure *TAutoDeleteRowEvent)(System::TObject* Sender, int aRow);

typedef void __fastcall (__closure *TAutoInsertColEvent)(System::TObject* Sender, int ACol);

typedef void __fastcall (__closure *TGridProgressEvent)(System::TObject* Sender, short progress);

typedef void __fastcall (__closure *TClipboardEvent)(System::TObject* Sender, bool &allow);

typedef void __fastcall (__closure *TClickSortEvent)(System::TObject* Sender, int aCol);

typedef void __fastcall (__closure *TCanSortEvent)(System::TObject* Sender, int aCol, bool &dosort);
	

typedef void __fastcall (__closure *TNodeClickEvent)(System::TObject* Sender, int arow, int arowreal
	);

typedef void __fastcall (__closure *TCustomCompareEvent)(System::TObject* Sender, AnsiString str1, AnsiString 
	str2, int &res);

typedef void __fastcall (__closure *TRawCompareEvent)(System::TObject* Sender, int col, int row1, int 
	row2, int &res);

typedef void __fastcall (__closure *TGridFormatEvent)(System::TObject* Sender, int ACol, TSortStyle 
	&AStyle, AnsiString &aPrefix, AnsiString &aSuffix);

typedef void __fastcall (__closure *TGridColorEvent)(System::TObject* Sender, int ARow, int ACol, Grids::TGridDrawState 
	AState, Graphics::TBrush* ABrush, Graphics::TFont* AFont);

typedef void __fastcall (__closure *TGridBorderEvent)(System::TObject* Sender, int ARow, int ACol, Graphics::TPen* 
	APen, TCellBorders &borders);

typedef void __fastcall (__closure *TGridAlignEvent)(System::TObject* Sender, int ARow, int ACol, Classes::TAlignment 
	&AAlignment);

typedef void __fastcall (__closure *TGridHintEvent)(System::TObject* Sender, int Arow, int Acol, AnsiString 
	&hintstr);

typedef void __fastcall (__closure *TOleDragDropEvent)(System::TObject* Sender, int Arow, int Acol, 
	AnsiString data, bool &allow);

typedef void __fastcall (__closure *TRowChangingEvent)(System::TObject* Sender, int OldRow, int NewRow
	, bool &Allow);

typedef void __fastcall (__closure *TColChangingEvent)(System::TObject* Sender, int OldCol, int NewCol
	, bool &Allow);

typedef void __fastcall (__closure *TCellChangingEvent)(System::TObject* Sender, int OldRow, int OldCol
	, int NewRow, int NewCol, bool &Allow);

typedef void __fastcall (__closure *TScrollHintEvent)(System::TObject* Sender, int Arow, AnsiString 
	&hintstr);

typedef void __fastcall (__closure *TGridPrintPageEvent)(System::TObject* Sender, Graphics::TCanvas* 
	Canvas, int pagenr, int pagexsize, int pageysize);

typedef void __fastcall (__closure *TGridPrintStartEvent)(System::TObject* Sender, int NrOfPages, int 
	&FromPage, int &ToPage);

typedef void __fastcall (__closure *TGridPrintNewPageEvent)(System::TObject* Sender, int aRow, bool 
	&newpage);

typedef void __fastcall (__closure *TGridPrintColumnWidthEvent)(System::TObject* Sender, int aCol, int 
	&width);

typedef void __fastcall (__closure *TGridPrintRowHeightEvent)(System::TObject* Sender, int aRow, int 
	&height);

typedef void __fastcall (__closure *TOnResizeEvent)(System::TObject* Sender);

typedef void __fastcall (__closure *TColumnSizeEvent)(System::TObject* Sender, int aCol, bool &allow
	);

typedef void __fastcall (__closure *TEndColumnSizeEvent)(System::TObject* Sender, int aCol);

typedef void __fastcall (__closure *TEndRowSizeEvent)(System::TObject* Sender, int aRow);

typedef void __fastcall (__closure *TClickCellEvent)(System::TObject* Sender, int arow, int acol);

typedef void __fastcall (__closure *TDblClickCellEvent)(System::TObject* Sender, int aRow, int aCol)
	;

typedef void __fastcall (__closure *TCanEditCellEvent)(System::TObject* Sender, int aRow, int aCol, 
	bool &canedit);

typedef void __fastcall (__closure *TIsFixedCellEvent)(System::TObject* Sender, int aRow, int aCol, 
	bool &isfixed);

typedef void __fastcall (__closure *TIsPasswordCellEvent)(System::TObject* Sender, int aRow, int aCol
	, bool &ispassword);

typedef void __fastcall (__closure *TAnchorClickEvent)(System::TObject* Sender, int aRow, int aCol, 
	AnsiString anchor, bool &AutoHandle);

typedef void __fastcall (__closure *TAnchorEvent)(System::TObject* Sender, int aRow, int aCol, AnsiString 
	anchor);

typedef void __fastcall (__closure *TCellValidateEvent)(System::TObject* Sender, int Col, int Row, AnsiString 
	&Value, bool &Valid);

typedef void __fastcall (__closure *TDoFitToPageEvent)(System::TObject* Sender, double &scalefactor, 
	bool &allow);

#pragma option push -b-
enum TFindParameters { fnMatchCase, fnMatchFull, fnMatchRegular, fnDirectionLeftRight, fnMatchStart, 
	fnFindInCurrentRow, fnFindInCurrentCol, fnIncludeFixed, fnAutoGoto };
#pragma option pop

#pragma option push -b-
enum TCellHAlign { haLeft, haRight, haCenter, haBeforeText, haAfterText, haFull };
#pragma option pop

#pragma option push -b-
enum TCellVAlign { vaTop, vaBottom, vaCenter, vaUnderText, vaAboveText, vaFull };
#pragma option pop

#pragma option push -b-
enum TCellType { ctBitmap, ctIcon, ctNone, ctImageList, ctCheckBox, ctDataCheckBox, ctRotated, ctDataImage, 
	ctNode, ctRadio, ctEmpty, ctImages, ctPicture, ctFilePicture, ctValue, ctProgress, ctComment, ctButton 
	};
#pragma option pop

#pragma option push -b-
enum TFitToPage { fpNever, fpGrow, fpShrink, fpAlways, fpCustom };
#pragma option pop

typedef Set<TFindParameters, fnMatchCase, fnAutoGoto>  TFindParams;

#pragma option push -b-
enum TStretchMode { noStretch, Stretch, StretchWithAspectRatio, Shrink, ShrinkWithAspectRatio };
#pragma option pop

class DELPHICLASS TCellGraphic;
class PASCALIMPLEMENTATION TCellGraphic : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TCellType CellType;
	Graphics::TBitmap* CellBitmap;
	Graphics::TIcon* CellIcon;
	TCellVAlign CellVAlign;
	TCellHAlign CellHAlign;
	int CellIndex;
	bool CellTransparent;
	bool CellCreated;
	bool CellBoolean;
	short CellAngle;
	double CellValue;
	System::TObject* CellObject;
	int CellData;
	Graphics::TColor CellColor;
	__fastcall TCellGraphic(void);
	__fastcall virtual ~TCellGraphic(void);
	void __fastcall SetBitmap(Graphics::TBitmap* abmp, bool transparent, TCellHAlign hal, TCellVAlign val
		);
	void __fastcall SetPicture(Graphics::TPicture* apicture, bool transparent, TStretchMode stretchmode
		, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetFilePicture(Advobj::TFilePicture* apicture, bool transparent, TStretchMode stretchmode
		, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetImageIdx(int idx, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetDataImage(int idx, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetMultiImage(int col, int row, int dir, TCellHAlign hal, TCellVAlign val, Advobj::TImageChangeEvent 
		notifier);
	void __fastcall SetIcon(Graphics::TIcon* aicon, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetCheckBox(bool value, bool data, TCellHAlign hal, TCellVAlign val);
	void __fastcall SetAngle(short aAngle);
	void __fastcall SetButton(int bw, int bh, AnsiString caption, TCellHAlign hal, TCellVAlign val);
	Windows::TPoint __fastcall GetPictureSize(int cw, int rh, bool hastext);
};


class DELPHICLASS TBands;
class DELPHICLASS TAdvStringGrid;
class DELPHICLASS TBackGround;
#pragma option push -b-
enum TBackGroundDisplay { bdTile, bdFixed };
#pragma option pop

#pragma option push -b-
enum TBackGroundCells { bcNormal, bcFixed };
#pragma option pop

class PASCALIMPLEMENTATION TBackGround : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TAdvStringGrid* fGrid;
	int ftop;
	int fleft;
	TBackGroundDisplay fdisplay;
	TBackGroundCells fBackgroundCells;
	void __fastcall SetBitmap(Graphics::TBitmap* value);
	void __fastcall SetTop(int value);
	void __fastcall SetLeft(int value);
	void __fastcall SetDisplay(TBackGroundDisplay value);
	void __fastcall SetBackGroundCells(const TBackGroundCells Value);
	Graphics::TBitmap* fBitmap;
	
public:
	__fastcall TBackGround(TAdvStringGrid* aGrid);
	__fastcall virtual ~TBackGround(void);
	
__published:
	__property int Top = {read=ftop, write=SetTop, nodefault};
	__property int Left = {read=fleft, write=SetLeft, nodefault};
	__property TBackGroundDisplay Display = {read=fdisplay, write=SetDisplay, nodefault};
	__property Graphics::TBitmap* Bitmap = {read=fBitmap, write=SetBitmap};
	__property TBackGroundCells Cells = {read=fBackgroundCells, write=SetBackGroundCells, nodefault};
};


class DELPHICLASS TPrintsettings;
class PASCALIMPLEMENTATION TPrintsettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TPrintPosition FTime;
	TPrintPosition FDate;
	TPrintPosition FPageNr;
	AnsiString FPageNumSep;
	AnsiString FDateFormat;
	TPrintPosition FTitle;
	Graphics::TFont* FFont;
	Graphics::TFont* FHeaderFont;
	Graphics::TFont* FFooterFont;
	TPrintBorders FBorders;
	Graphics::TPenStyle FBorderStyle;
	AnsiString FTitleText;
	Classes::TStringList* FTitleLines;
	bool FCentered;
	bool FRepeatFixedRows;
	bool FRepeatFixedCols;
	int FFooterSize;
	int FHeaderSize;
	int FLeftSize;
	int FRightSize;
	int FColumnSpacing;
	int FRowSpacing;
	int FTitleSpacing;
	Printers::TPrinterOrientation FOrientation;
	AnsiString FPagePrefix;
	AnsiString FPageSuffix;
	int FFixedHeight;
	bool FUseFixedHeight;
	int FFixedWidth;
	bool FUseFixedWidth;
	TFitToPage FFitToPage;
	bool FNoAutoSize;
	bool FPrintGraphics;
	AnsiString FJobName;
	void __fastcall SetPrintFont(Graphics::TFont* value);
	void __fastcall SetPrintHeaderFont(Graphics::TFont* value);
	void __fastcall SetPrintFooterFont(Graphics::TFont* value);
	void __fastcall SetTitleLines(Classes::TStringList* value);
	
public:
	__fastcall TPrintsettings(void);
	__fastcall virtual ~TPrintsettings(void);
	
__published:
	__property int FooterSize = {read=FFooterSize, write=FFooterSize, nodefault};
	__property int HeaderSize = {read=FHeaderSize, write=FHeaderSize, nodefault};
	__property TPrintPosition Time = {read=FTime, write=FTime, nodefault};
	__property TPrintPosition Date = {read=FDate, write=FDate, nodefault};
	__property AnsiString DateFormat = {read=FDateFormat, write=FDateFormat};
	__property TPrintPosition PageNr = {read=FPageNr, write=FPageNr, nodefault};
	__property TPrintPosition Title = {read=FTitle, write=FTitle, nodefault};
	__property AnsiString TitleText = {read=FTitleText, write=FTitleText};
	__property Classes::TStringList* TitleLines = {read=FTitleLines, write=SetTitleLines};
	__property Graphics::TFont* Font = {read=FFont, write=SetPrintFont};
	__property Graphics::TFont* HeaderFont = {read=FHeaderFont, write=SetPrintHeaderFont};
	__property Graphics::TFont* FooterFont = {read=FFooterFont, write=SetPrintFooterFont};
	__property TPrintBorders Borders = {read=FBorders, write=FBorders, nodefault};
	__property Graphics::TPenStyle BorderStyle = {read=FBorderStyle, write=FBorderStyle, nodefault};
	__property bool Centered = {read=FCentered, write=FCentered, nodefault};
	__property bool RepeatFixedRows = {read=FRepeatFixedRows, write=FRepeatFixedRows, nodefault};
	__property bool RepeatFixedCols = {read=FRepeatFixedCols, write=FRepeatFixedCols, nodefault};
	__property int LeftSize = {read=FLeftSize, write=FLeftSize, nodefault};
	__property int RightSize = {read=FRightSize, write=FRightSize, nodefault};
	__property int ColumnSpacing = {read=FColumnSpacing, write=FColumnSpacing, nodefault};
	__property int RowSpacing = {read=FRowSpacing, write=FRowSpacing, nodefault};
	__property int TitleSpacing = {read=FTitleSpacing, write=FTitleSpacing, nodefault};
	__property Printers::TPrinterOrientation Orientation = {read=FOrientation, write=FOrientation, nodefault
		};
	__property AnsiString PagePrefix = {read=FPagePrefix, write=FPagePrefix, stored=true};
	__property AnsiString PageSuffix = {read=FPageSuffix, write=FPageSuffix};
	__property int FixedWidth = {read=FFixedWidth, write=FFixedWidth, nodefault};
	__property int FixedHeight = {read=FFixedHeight, write=FFixedHeight, nodefault};
	__property bool UseFixedHeight = {read=FUseFixedHeight, write=FUseFixedHeight, nodefault};
	__property bool UseFixedWidth = {read=FUseFixedWidth, write=FUseFixedWidth, nodefault};
	__property TFitToPage FitToPage = {read=FFitToPage, write=FFitToPage, nodefault};
	__property AnsiString JobName = {read=FJobName, write=FJobName};
	__property AnsiString PageNumSep = {read=FPageNumSep, write=FPageNumSep};
	__property bool NoAutoSize = {read=FNoAutoSize, write=FNoAutoSize, nodefault};
	__property bool PrintGraphics = {read=FPrintGraphics, write=FPrintGraphics, nodefault};
};


class DELPHICLASS THTMLSettings;
class PASCALIMPLEMENTATION THTMLSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool fSaveColor;
	bool fSaveFonts;
	AnsiString fFooterFile;
	AnsiString fHeaderFile;
	int fBorderSize;
	int fCellSpacing;
	int fCellPadding;
	AnsiString fTableStyle;
	AnsiString fPrefixTag;
	AnsiString fSuffixTag;
	int fWidth;
	
public:
	__fastcall THTMLSettings(void);
	
__published:
	__property int BorderSize = {read=fBorderSize, write=fBorderSize, default=1};
	__property int CellSpacing = {read=fCellSpacing, write=fCellSpacing, default=0};
	__property int CellPadding = {read=fCellPadding, write=fCellPadding, default=0};
	__property bool SaveColor = {read=fSaveColor, write=fSaveColor, default=1};
	__property bool SaveFonts = {read=fSaveFonts, write=fSaveFonts, default=1};
	__property AnsiString FooterFile = {read=fFooterFile, write=fFooterFile};
	__property AnsiString HeaderFile = {read=fHeaderFile, write=fHeaderFile};
	__property AnsiString TableStyle = {read=fTableStyle, write=fTableStyle};
	__property AnsiString PrefixTag = {read=fPrefixTag, write=fPrefixTag};
	__property AnsiString SuffixTag = {read=fSuffixTag, write=fSuffixTag};
	__property int Width = {read=fWidth, write=fWidth, nodefault};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~THTMLSettings(void) { }
	#pragma option pop
	
};


class DELPHICLASS TNavigation;
class PASCALIMPLEMENTATION TNavigation : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FAllowInsertRow;
	bool FAllowDeleteRow;
	bool FAdvanceOnEnter;
	bool FAdvanceInsert;
	bool FAutoGotoWhenSorted;
	bool FAutoGotoIncremental;
	bool FAutoComboDropSize;
	bool FAllowClipboardShortcuts;
	bool FAllowRTFClipboard;
	bool FAllowSmartClipboard;
	bool FAllowClipboardAlways;
	bool FAllowClipboardColGrow;
	bool FAllowClipboardRowGrow;
	bool FCopyHTMLTagsToClipboard;
	TAdvanceDirection FAdvanceDirection;
	bool FAdvanceAuto;
	bool FCursorWalkEditor;
	bool FMoveRowOnSort;
	bool FImproveMaskSel;
	bool FAlwaysEdit;
	TInsertPosition FInsertPosition;
	bool FLineFeedOnEnter;
	void __fastcall SetAutoGoto(bool avalue);
	
public:
	__fastcall TNavigation(void);
	__fastcall virtual ~TNavigation(void);
	
__published:
	__property bool AllowInsertRow = {read=FAllowInsertRow, write=FAllowInsertRow, nodefault};
	__property bool AllowDeleteRow = {read=FAllowDeleteRow, write=FAllowDeleteRow, nodefault};
	__property bool AdvanceOnEnter = {read=FAdvanceOnEnter, write=FAdvanceOnEnter, nodefault};
	__property bool AdvanceInsert = {read=FAdvanceInsert, write=FAdvanceInsert, nodefault};
	__property bool AutoGotoWhenSorted = {read=FAutoGotoWhenSorted, write=SetAutoGoto, nodefault};
	__property bool AutoGotoIncremental = {read=FAutoGotoIncremental, write=FAutoGotoIncremental, nodefault
		};
	__property bool AutoComboDropSize = {read=FAutoComboDropSize, write=FAutoComboDropSize, nodefault};
		
	__property TAdvanceDirection AdvanceDirection = {read=FAdvanceDirection, write=FAdvanceDirection, nodefault
		};
	__property bool AllowClipboardShortCuts = {read=FAllowClipboardShortcuts, write=FAllowClipboardShortcuts
		, nodefault};
	__property bool AllowSmartClipboard = {read=FAllowSmartClipboard, write=FAllowSmartClipboard, nodefault
		};
	__property bool AllowRTFClipboard = {read=FAllowRTFClipboard, write=FAllowRTFClipboard, nodefault};
		
	__property bool AllowClipboardAlways = {read=FAllowClipboardAlways, write=FAllowClipboardAlways, nodefault
		};
	__property bool AllowClipboardRowGrow = {read=FAllowClipboardRowGrow, write=FAllowClipboardRowGrow, 
		nodefault};
	__property bool AllowClipboardColGrow = {read=FAllowClipboardColGrow, write=FAllowClipboardColGrow, 
		nodefault};
	__property bool AdvanceAuto = {read=FAdvanceAuto, write=FAdvanceAuto, nodefault};
	__property TInsertPosition InsertPosition = {read=FInsertPosition, write=FInsertPosition, nodefault
		};
	__property bool CursorWalkEditor = {read=FCursorWalkEditor, write=FCursorWalkEditor, nodefault};
	__property bool MoveRowOnSort = {read=FMoveRowOnSort, write=FMoveRowOnSort, nodefault};
	__property bool ImproveMaskSel = {read=FImproveMaskSel, write=FImproveMaskSel, nodefault};
	__property bool AlwaysEdit = {read=FAlwaysEdit, write=FAlwaysEdit, nodefault};
	__property bool CopyHTMLTagsToClipboard = {read=FCopyHTMLTagsToClipboard, write=FCopyHTMLTagsToClipboard
		, nodefault};
	__property bool LineFeedOnEnter = {read=FLineFeedOnEnter, write=FLineFeedOnEnter, nodefault};
};


class DELPHICLASS TColumnSize;
#pragma option push -b-
enum TColumnSizeLocation { clRegistry, clInifile };
#pragma option pop

class PASCALIMPLEMENTATION TColumnSize : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FSave;
	AnsiString FKey;
	AnsiString FSection;
	bool FStretch;
	TColumnSizeLocation FLocation;
	Classes::TComponent* Owner;
	void __fastcall SetStretch(bool value);
	
public:
	__fastcall TColumnSize(Classes::TComponent* aOwner);
	__fastcall virtual ~TColumnSize(void);
	
__published:
	__property bool Save = {read=FSave, write=FSave, nodefault};
	__property AnsiString Key = {read=FKey, write=FKey};
	__property AnsiString Section = {read=FSection, write=FSection};
	__property bool Stretch = {read=FStretch, write=SetStretch, nodefault};
	__property TColumnSizeLocation Location = {read=FLocation, write=FLocation, nodefault};
};


class DELPHICLASS TCellNode;
#pragma option push -b-
enum TNodeType { cnFlat, cn3D, cnGlyph };
#pragma option pop

class PASCALIMPLEMENTATION TCellNode : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor fColor;
	TNodeType fNodeType;
	Graphics::TColor fNodeColor;
	Graphics::TBitmap* fExpandGlyph;
	Graphics::TBitmap* fContractGlyph;
	TAdvStringGrid* fOwner;
	void __fastcall SetExpandGlyph(Graphics::TBitmap* value);
	void __fastcall SetContractGlyph(Graphics::TBitmap* value);
	void __fastcall SetNodeType(TNodeType value);
	
public:
	__fastcall TCellNode(TAdvStringGrid* aOwner);
	__fastcall virtual ~TCellNode(void);
	
__published:
	__property Graphics::TColor Color = {read=fColor, write=fColor, nodefault};
	__property TNodeType NodeType = {read=fNodeType, write=SetNodeType, nodefault};
	__property Graphics::TColor NodeColor = {read=fNodeColor, write=fNodeColor, nodefault};
	__property Graphics::TBitmap* ExpandGlyph = {read=fExpandGlyph, write=SetExpandGlyph};
	__property Graphics::TBitmap* ContractGlyph = {read=fContractGlyph, write=SetContractGlyph};
};


class DELPHICLASS TSizeWhileTyping;
class PASCALIMPLEMENTATION TSizeWhileTyping : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FHeight;
	bool FWidth;
	
public:
	__fastcall TSizeWhileTyping(void);
	__fastcall virtual ~TSizeWhileTyping(void);
	
__published:
	__property bool Height = {read=FHeight, write=FHeight, nodefault};
	__property bool Width = {read=FWidth, write=FWidth, nodefault};
};


class DELPHICLASS TMouseActions;
class PASCALIMPLEMENTATION TMouseActions : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FColSelect;
	bool FRowSelect;
	bool FAllSelect;
	bool FDirectEdit;
	bool FDirectComboDrop;
	bool FDisjunctRowSelect;
	bool FAllColumnSize;
	bool FAllRowSize;
	bool FCaretPositioning;
	
public:
	__fastcall TMouseActions(void);
	__fastcall virtual ~TMouseActions(void);
	
__published:
	__property bool AllSelect = {read=FAllSelect, write=FAllSelect, nodefault};
	__property bool ColSelect = {read=FColSelect, write=FColSelect, nodefault};
	__property bool RowSelect = {read=FRowSelect, write=FRowSelect, nodefault};
	__property bool DirectEdit = {read=FDirectEdit, write=FDirectEdit, nodefault};
	__property bool DirectComboDrop = {read=FDirectComboDrop, write=FDirectComboDrop, nodefault};
	__property bool DisjunctRowSelect = {read=FDisjunctRowSelect, write=FDisjunctRowSelect, nodefault};
		
	__property bool AllColumnSize = {read=FAllColumnSize, write=FAllColumnSize, nodefault};
	__property bool AllRowSize = {read=FAllRowSize, write=FAllRowSize, nodefault};
	__property bool CaretPositioning = {read=FCaretPositioning, write=FCaretPositioning, nodefault};
};


class DELPHICLASS TAdvRichEdit;
class PASCALIMPLEMENTATION TAdvRichEdit : public Comctrls::TRichEdit 
{
	typedef Comctrls::TRichEdit inherited;
	
private:
	void __fastcall SelFormat(int offset);
	
public:
	void __fastcall SelSubscript(void);
	void __fastcall SelSuperscript(void);
	void __fastcall SelNormal(void);
public:
	#pragma option push -w-inl
	/* TCustomRichEdit.Create */ inline __fastcall virtual TAdvRichEdit(Classes::TComponent* AOwner) : 
		Comctrls::TRichEdit(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomRichEdit.Destroy */ inline __fastcall virtual ~TAdvRichEdit(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TAdvRichEdit(HWND ParentWindow) : Comctrls::TRichEdit(
		ParentWindow) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TMouseSelectMode { msNormal, msColumn, msRow, msAll, msURL };
#pragma option pop

class DELPHICLASS TEditLink;
typedef void __fastcall (__closure *TGetEditorPropEvent)(System::TObject* Sender, int aCol, int aRow
	, TEditLink* aEditLink);

class DELPHICLASS TGridCombo;
class PASCALIMPLEMENTATION TGridCombo : public Advcombo::TAdvComboBox 
{
	typedef Advcombo::TAdvComboBox inherited;
	
private:
	bool forced;
	bool workmode;
	int itemidx;
	bool itemchange;
	MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	
public:
	TAdvStringGrid* grid;
	void __fastcall DoChange(void);
	__fastcall virtual TGridCombo(Classes::TComponent* aOwner);
	void __fastcall SizeDropDownWidth(void);
	
protected:
	DYNAMIC void __fastcall KeyPress(char &key);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
public:
	#pragma option push -w-inl
	/* TCustomComboBox.Destroy */ inline __fastcall virtual ~TGridCombo(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridCombo(HWND ParentWindow) : Advcombo::TAdvComboBox(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TGridSpin;
class PASCALIMPLEMENTATION TGridSpin : public Asgspin::TAsgSpinEdit 
{
	typedef Asgspin::TAsgSpinEdit inherited;
	
private:
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	
protected:
	virtual void __fastcall UpClick(System::TObject* Sender);
	virtual void __fastcall DownClick(System::TObject* Sender);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall Keypress(char &key);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* grid;
	__fastcall virtual TGridSpin(Classes::TComponent* aOwner);
public:
	#pragma option push -w-inl
	/* TAsgSpinEdit.Destroy */ inline __fastcall virtual ~TGridSpin(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridSpin(HWND ParentWindow) : Asgspin::TAsgSpinEdit(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TGridDatePicker;
class PASCALIMPLEMENTATION TGridDatePicker : public Comctrls::TDateTimePicker 
{
	typedef Comctrls::TDateTimePicker inherited;
	
private:
	HIDESBASE MESSAGE void __fastcall WMNCPaint(Messages::TMessage &Message);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* grid;
	__fastcall virtual TGridDatePicker(Classes::TComponent* aOwner);
public:
	#pragma option push -w-inl
	/* TCommonCalendar.Destroy */ inline __fastcall virtual ~TGridDatePicker(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridDatePicker(HWND ParentWindow) : Comctrls::TDateTimePicker(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TGridCheckBox;
class PASCALIMPLEMENTATION TGridCheckBox : public Stdctrls::TCheckBox 
{
	typedef Stdctrls::TCheckBox inherited;
	
private:
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Msg);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* grid;
	__fastcall virtual TGridCheckBox(Classes::TComponent* aOwner);
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridCheckBox(HWND ParentWindow) : Stdctrls::TCheckBox(
		ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TGridCheckBox(void) { }
	#pragma option pop
	
};


class DELPHICLASS TGridEditBtn;
class PASCALIMPLEMENTATION TGridEditBtn : public Asgedit::TAsgEditBtn 
{
	typedef Asgedit::TAsgEditBtn inherited;
	
private:
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	
protected:
	void __fastcall ExtClick(System::TObject* Sender);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall Keypress(char &key);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* grid;
	__fastcall virtual TGridEditBtn(Classes::TComponent* aOwner);
public:
	#pragma option push -w-inl
	/* TAsgEditBtn.Destroy */ inline __fastcall virtual ~TGridEditBtn(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridEditBtn(HWND ParentWindow) : Asgedit::TAsgEditBtn(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TGridUnitEditBtn;
class PASCALIMPLEMENTATION TGridUnitEditBtn : public Asgedit::TAsgUnitEditBtn 
{
	typedef Asgedit::TAsgUnitEditBtn inherited;
	
private:
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	
protected:
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* grid;
	__fastcall virtual TGridUnitEditBtn(Classes::TComponent* aOwner);
public:
	#pragma option push -w-inl
	/* TAsgUnitEditBtn.Destroy */ inline __fastcall virtual ~TGridUnitEditBtn(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridUnitEditBtn(HWND ParentWindow) : Asgedit::TAsgUnitEditBtn(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TGridButton;
class PASCALIMPLEMENTATION TGridButton : public Stdctrls::TButton 
{
	typedef Stdctrls::TButton inherited;
	
protected:
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Msg);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall DoExit(void);
	
public:
	TAdvStringGrid* grid;
	__fastcall virtual TGridButton(Classes::TComponent* aOwner);
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TGridButton(HWND ParentWindow) : Stdctrls::TButton(
		ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TGridButton(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFilter;
class DELPHICLASS TFilterData;
class PASCALIMPLEMENTATION TFilter : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TAdvStringGrid* fOwner;
	HIDESBASE TFilterData* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TFilterData* Value);
	
public:
	__fastcall TFilter(TAdvStringGrid* aOwner);
	HIDESBASE TFilterData* __fastcall Add(void);
	HIDESBASE TFilterData* __fastcall Insert(int index);
	__property TFilterData* Items[int Index] = {read=GetItem, write=SetItem};
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TAdvInplaceEdit;
#pragma option push -b-
enum TClipOperation { coCut, coCopy };
#pragma option pop

class PASCALIMPLEMENTATION TAdvStringGrid : public Grids::TStringGrid 
{
	typedef Grids::TStringGrid inherited;
	
private:
	AnsiString cla;
	int FMoveColInd;
	int FMoveRowInd;
	int FSortColumn;
	int FGroupColumn;
	AnsiString FGroupCaption;
	int FGroupWidth;
	bool FSortShow;
	bool FSortIndexShow;
	bool FSortFull;
	bool FSortAutoFormat;
	TSortDirection FSortDirection;
	bool FAutoSize;
	bool FAutoNumAlign;
	bool FEnhTextSize;
	bool FOemConvert;
	bool FLookup;
	bool FLookupCaseSensitive;
	bool FDeselectState;
	bool FMouseDown;
	bool FLookupHistory;
	bool FEnhRowColMove;
	bool FSizeWithForm;
	bool FMultilinecells;
	unsigned FRTLReadingMode;
	bool FSortFixedCols;
	bool FSortNormalCellsOnly;
	TGridColorEvent FOnGetCellColor;
	TGridColorEvent FOnGetCellPrintColor;
	TGridBorderEvent FOnGetCellBorder;
	TGridBorderEvent FOnGetCellPrintBorder;
	TGridAlignEvent FOnGetAlignment;
	TGridFormatEvent FOnGetFormat;
	TGridHintEvent FOnGridHint;
	TRowChangingEvent FOnRowChanging;
	TColChangingEvent FOnColChanging;
	TCellChangingEvent FOnCellChanging;
	Forms::TShowHintEvent FOnShowHint;
	TCanAddRowEvent FOnCanAddRow;
	TAutoAddRowEvent FOnAutoAddRow;
	TCanInsertRowEvent FOnCanInsertRow;
	TAutoInsertRowEvent FOnAutoInsertRow;
	TAutoInsertColEvent FOnAutoInsertCol;
	TCanDeleteRowEvent FOnCanDeleteRow;
	TAutoDeleteRowEvent FOnAutoDeleteRow;
	TOleDragDropEvent FOnOleDrop;
	TOleDragDropEvent FOnOleDrag;
	TClickSortEvent FOnClickSort;
	TCanSortEvent FOnCanSort;
	TNodeClickEvent FOnExpandNode;
	TNodeClickEvent FOnContractNode;
	TCustomCompareEvent FCustomCompare;
	TRawCompareEvent FRawCompare;
	TClipboardEvent FOnClipboardPaste;
	TClipboardEvent FOnClipboardCut;
	TClipboardEvent FonClipboardCopy;
	TOnResizeEvent FOnResize;
	TGridPrintStartEvent FOnPrintStart;
	TGridPrintPageEvent FOnPrintPage;
	TGridPrintNewPageEvent FOnPrintNewPage;
	TGridPrintColumnWidthEvent FOnPrintSetColumnWidth;
	TGridPrintRowHeightEvent FOnPrintSetRowHeight;
	TDoFitToPageEvent FDoFitToPage;
	TClickCellEvent FOnClickCell;
	TClickCellEvent FOnRightClickCell;
	TDblClickCellEvent FOnDblClickCell;
	TCanEditCellEvent FOnCanEditCell;
	TIsFixedCellEvent FOnIsFixedCell;
	TIsPasswordCellEvent FOnIsPasswordCell;
	TAnchorClickEvent FOnAnchorClick;
	TAnchorEvent FOnAnchorEnter;
	TAnchorEvent FOnAnchorExit;
	TCellValidateEvent FOnCellValidate;
	TGridProgressEvent FOnFileProgress;
	Graphics::TColor FHintColor;
	bool FHintShowCells;
	bool FHintShowLargeText;
	Windows::TPoint FLastHintPos;
	Graphics::TBitmap* FSortUpGlyph;
	Graphics::TBitmap* FSortDownGlyph;
	Advobj::TSortIndexList* FSortIndexes;
	TBackGround* FBackGround;
	Advobj::TArrowWindow* ArwU;
	Advobj::TArrowWindow* ArwD;
	Advobj::TArrowWindow* ArwL;
	Advobj::TArrowWindow* ArwR;
	TColumnSizeEvent FOnColumnSize;
	TEndColumnSizeEvent FOnEndColumnSize;
	TEndRowSizeEvent FOnEndRowSize;
	TPrintsettings* FPrintSettings;
	bool FFastPrint;
	THTMLSettings* FHTMLSettings;
	TBands* FBands;
	TNavigation* FNavigation;
	TColumnSize* FColumnSize;
	bool FScrollProportional;
	TCellNode* FCellNode;
	TSizeWhileTyping* FSizeWhileTyping;
	TMouseActions* FMouseActions;
	bool FVisiblecol[257];
	short FAllColWidths[257];
	int FUpdateCount;
	int FNumNodes;
	int FNumHidden;
	Graphics::TColor FSelectionColor;
	Graphics::TColor FSelectionTextColor;
	bool FSelectionRectangle;
	bool FSelectionRTFKeep;
	TVAlignment FVAlignment;
	unsigned FVAlign;
	bool FURLShow;
	bool FURLFull;
	Graphics::TColor FURLColor;
	bool FURLEdit;
	Controls::TImageList* FGridImages;
	TIntelliPan FIntelliPan;
	TScrollType FScrollType;
	Graphics::TColor FScrollColor;
	int FScrollWidth;
	bool FScrollSynch;
	TScrollHintType FScrollHints;
	Controls::THintWindow* FScrollHintWnd;
	bool FScrollHintShow;
	bool FIsFlat;
	TAdvRichEdit* FRichEdit;
	bool FFixedAsButtons;
	bool FFixedCellPushed;
	Windows::TRect FPushedFixedCell;
	Windows::TRect FRTFLastRect;
	Windows::TPoint FPushedCellButton;
	bool FShowSelection;
	bool FHideFocusRect;
	Graphics::TFont* FFixedFont;
	Classes::TStringList* FColumnHeaders;
	Classes::TStringList* FRowHeaders;
	Classes::TStringList* FLookupItems;
	Classes::TList* FRowSelect;
	int FFixedFooters;
	int FFixedRightCols;
	char FDelimiter;
	char FPasswordChar;
	bool FJavaCSV;
	AnsiString FCheckTrue;
	AnsiString FCheckFalse;
	bool FEnableGraphics;
	bool FEnableHTML;
	bool FSaveFixedCells;
	bool FSaveHiddenCells;
	bool FWordWrap;
	bool FModified;
	bool FHovering;
	AnsiString FFloatFormat;
	AnsiString fOldCellText;
	char fStartEditChar;
	int fOldCol;
	int fOldRow;
	bool fOldModifiedValue;
	int fOldCursor;
	bool fBlockFocus;
	bool fDblClk;
	Grids::TGridRect fOldSelection;
	Grids::TGridRect fMoveSelection;
	bool fEntered;
	bool fFindBusy;
	int fComboIdx;
	int sortdir;
	int sortrow;
	Windows::TPoint searchcell;
	Windows::TPoint startcell;
	bool showhintassigned;
	bool resizeassigned;
	Grids::TGridRect fprintrect;
	TFindParams ffindparams;
	AnsiString cellcache;
	AnsiString searchcache;
	AnsiString searchinc;
	AnsiString fAnchor;
	int zoomfactor;
	bool colchgflg;
	bool colmoveflg;
	bool colsizeflg;
	bool colsized;
	bool rowsized;
	int colclicked;
	int rowclicked;
	int colclickedsize;
	int rowclickedsize;
	int movecell;
	int moveofsx;
	int moveofsy;
	int clickposx;
	int clickposy;
	int clickposdx;
	int clickposdy;
	bool invokedchange;
	unsigned wheelmsg;
	int wheelscrl;
	bool wheelpan;
	Windows::TPoint wheelpanpos;
	unsigned wheeltimer;
	HICON prevcurs;
	TMouseSelectMode fmouseselectmode;
	bool fprinterdriverfix;
	Windows::TRect prevrect;
	double fontscalefactor;
	int fprintpagewidth;
	Windows::TRect fprintpagerect;
	int fprintcolstart;
	int fprintcolend;
	int fprintpagefrom;
	int fprintpageto;
	int fprintpagenum;
	bool fExcelClipboardFormat;
	int fGridTimerID;
	bool fGridBlink;
	int fMaxEditLength;
	int maxwidths[257];
	int indents[257];
	TGetEditorTypeEvent FOnGetEditorType;
	TGetEditorPropEvent FOnGetEditorProp;
	TEllipsClickEvent FOnEllipsClick;
	TButtonClickEvent FOnButtonClick;
	TCheckBoxClickEvent FOnCheckBoxClick;
	TCheckBoxClickEvent FOnCheckBoxMouseUp;
	TRadioClickEvent FOnRadioClick;
	TRadioClickEvent FOnRadioMouseUp;
	TComboChangeEvent FOnComboChange;
	TSpinClickEvent FOnSpinClick;
	TFloatSpinClickEvent FOnFloatSpinClick;
	TDateTimeSpinClickEvent FOnTimeSpinClick;
	TDateTimeSpinClickEvent FOnDateSpinClick;
	TEditLink* fEditLink;
	TGridCombo* editcombo;
	TGridSpin* editspin;
	TGridDatePicker* editdate;
	TScrollHintEvent FOnScrollHint;
	TGridCheckBox* editcheck;
	TGridEditBtn* editbtn;
	TGridUnitEditBtn* uniteditbtn;
	TGridButton* gridbutton;
	TGridButton* movebutton;
	TEditorType editcontrol;
	Classes::TCollection* fgriditems;
	TFilter* ffilter;
	bool ffilterActive;
	int ffilterFixedRows;
	void __fastcall RestoreCache(void);
	void __fastcall HideEditControl(int acol, int arow);
	void __fastcall ShowEditControl(int acol, int arow);
	bool __fastcall IsFixed(int Acol, int Arow);
	bool __fastcall IsEditable(int Acol, int Arow);
	bool __fastcall IsPassword(int Acol, int Arow);
	void __fastcall HandleRadioClick(int Acol, int Arow, int Xpos, int Ypos);
	bool __fastcall HasStaticEdit(int Acol, int Arow);
	void __fastcall AdvanceEdit(int acol, int arow, bool advance, bool show, bool frwrd);
	TAdvInplaceEdit* __fastcall GetInplaceEditor(void);
	bool __fastcall ToggleCheck(int Acol, int Arow, bool fromedit);
	HIDESBASE void __fastcall SetAutoSize(bool aAutoSize);
	void __fastcall SetShowSelection(bool avalue);
	void __fastcall SetSortShow(const bool AValue);
	void __fastcall SetSortIndexShow(const bool AValue);
	void __fastcall SetSortColumn(int aSortColumn);
	void __fastcall SetMaxEditLength(const int AValue);
	void __fastcall SetGroupColumn(int aGroupColumn);
	void __fastcall QuickSortRows(int col, int left, int right);
	void __fastcall QuickSortRowsIndexed(int col, int left, int right);
	void __fastcall SetVAlignment(TVAlignment aVAlignment);
	int __fastcall BuildPages(Graphics::TCanvas* canvas, TPrintMethod printmethod, int maxpages);
	int __fastcall Compare(int col, int arow1, int arow2);
	int __fastcall CompareLine(int col, int arow1, int arow2);
	int __fastcall CompareLineIndexed(int colidx, int arow1, int arow2);
	bool __fastcall MatchCell(int col, int row);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMSetCursor(Messages::TWMSetCursor &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMRButtonDown(Messages::TWMMouse &Msg);
	HIDESBASE MESSAGE void __fastcall WMLButtonDblClk(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &Msg);
	HIDESBASE MESSAGE void __fastcall WMEraseBkGnd(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall WMTimer(Messages::TWMTimer &Msg);
	HIDESBASE MESSAGE void __fastcall WMVScroll(Messages::TWMScroll &WMScroll);
	HIDESBASE MESSAGE void __fastcall WMHScroll(Messages::TWMScroll &WMScroll);
	HIDESBASE MESSAGE void __fastcall CMCursorChanged(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMHintShow(Messages::TMessage &Msg);
	void __fastcall ShowHintProc(AnsiString &HintStr, bool &CanShow, Forms::THintInfo &HintInfo);
	void __fastcall DrawSortIndicator(Graphics::TCanvas* canvas, int col, int x, int y);
	void __fastcall GridResize(System::TObject* Sender);
	TCellType __fastcall GetCellType(int ACol, int ARow);
	TCellGraphic* __fastcall GetCellGraphic(int ACol, int ARow);
	Windows::TPoint __fastcall GetCellGraphicSize(int ACol, int ARow);
	bool __fastcall FreeCellGraphic(int ACol, int ARow);
	bool __fastcall RemoveCellGraphic(int ACol, int ARow, TCellType celltype);
	TCellGraphic* __fastcall CreateCellGraphic(int ACol, int ARow);
	Advobj::TIntList* __fastcall GetCellImages(int Acol, int Arow);
	int __fastcall GetCellImageIdx(int Acol, int Arow);
	void __fastcall SetInts(int ACol, int ARow, const int Value);
	int __fastcall GetInts(int ACol, int ARow);
	void __fastcall SetFloats(int ACol, int ARow, const double Value);
	double __fastcall GetFloats(int ACol, int ARow);
	void __fastcall SetDates(int ACol, int ARow, const System::TDateTime Value);
	System::TDateTime __fastcall GetDates(int ACol, int ARow);
	void __fastcall SetTimes(int ACol, int ARow, const System::TDateTime Value);
	System::TDateTime __fastcall GetTimes(int ACol, int ARow);
	bool __fastcall GetRowSelect(int ARow);
	void __fastcall SetRowSelect(int ARow, bool value);
	int __fastcall GetRowSelectCount(void);
	Windows::TRect __fastcall ButtonRect(int Acol, int Arow);
	void __fastcall SelectToRowSelect(int aRow);
	void __fastcall SetFixedFont(Graphics::TFont* value);
	void __fastcall FixedFontChanged(System::TObject* Sender);
	void __fastcall MultiImageChanged(System::TObject* Sender, int Acol, int Arow);
	void __fastcall SetColumnHeaders(Classes::TStringList* Value);
	void __fastcall ColHeaderChanged(System::TObject* Sender);
	void __fastcall SetRowHeaders(Classes::TStringList* Value);
	void __fastcall RowHeaderChanged(System::TObject* Sender);
	int __fastcall GetPrintColWidth(int aCol);
	int __fastcall GetPrintColOffset(int aCol);
	void __fastcall SetLookupItems(Classes::TStringList* Value);
	int __fastcall PasteFunc(int acol, int arow);
	void __fastcall CopyFunc(const Grids::TGridRect &gd);
	void __fastcall CopyRTFFunc(int acol, int arow);
	void __fastcall SetPreviewPage(int value);
	Graphics::TBitmap* __fastcall GetUpGlyph(void);
	void __fastcall SetUpGlyph(Graphics::TBitmap* Value);
	Graphics::TBitmap* __fastcall GetDownGlyph(void);
	void __fastcall SetDownGlyph(Graphics::TBitmap* Value);
	void __fastcall SetBackground(TBackGround* Value);
	void __fastcall RTFPaint(int acol, int arow, Graphics::TCanvas* canvas, const Windows::TRect &arect
		);
	void __fastcall RTFResizeRequest(System::TObject* Sender, const Windows::TRect &Rect);
	void __fastcall FlatInit(void);
	void __fastcall FlatDone(void);
	void __fastcall FlatUpdate(void);
	void __fastcall FlatSetScrollProp(int index, int newValue, BOOL fRedraw);
	void __fastcall FlatSetScrollInfo(int code, tagSCROLLINFO &scrollinfo, BOOL fRedraw);
	void __fastcall FlatShowScrollBar(int code, BOOL show);
	void __fastcall UpdateVScrollBar(void);
	void __fastcall UpdateHScrollBar(void);
	void __fastcall UpdateType(void);
	void __fastcall UpdateColor(void);
	void __fastcall UpdateWidth(void);
	void __fastcall SetScrollType(const TScrollType Value);
	void __fastcall SetScrollColor(const Graphics::TColor Value);
	void __fastcall SetScrollWidth(const int Value);
	void __fastcall SetScrollProportional(bool value);
	bool __fastcall GetLockFlag(void);
	void __fastcall SetLockFlag(bool AValue);
	bool __fastcall InSizeZone(int x, int y);
	int __fastcall RemapCol(int acol);
	int __fastcall RemapColInv(int acol);
	int __fastcall RemapRow(int arow);
	int __fastcall RemapRowInv(int arow);
	void __fastcall setvisiblecol(int i, bool avalue);
	bool __fastcall getvisiblecol(int i);
	int __fastcall MaxLinesInGrid(void);
	int __fastcall MaxLinesInRow(int arow);
	int __fastcall MaxCharsInCol(int acol);
	void __fastcall SizeToLines(const int ARow, const int Lines, const int Padding);
	void __fastcall SizeToWidth(const int ACol, bool inconly);
	tagSIZE __fastcall GetCellTextSize(int aCol, int aRow);
	Classes::TAlignment __fastcall GetCellAlignment(int aCol, int aRow);
	void __fastcall DrawIntelliFocusPoint(void);
	void __fastcall EraseIntelliFocusPoint(void);
	void __fastcall SetImages(Controls::TImageList* value);
	void __fastcall SetURLShow(bool value);
	void __fastcall SetURLColor(Graphics::TColor value);
	void __fastcall SetURLFull(bool value);
	void __fastcall CalcTextPos(Windows::TRect &aRect, int aAngle, AnsiString aTxt, Classes::TAlignment 
		tal);
	void __fastcall SetFixedFooters(int value);
	void __fastcall SetFixedRightCols(int value);
	void __fastcall SetFixedColWidth(int value);
	void __fastcall SetHovering(bool value);
	int __fastcall GetFixedColWidth(void);
	void __fastcall SetFixedRowHeight(int value);
	int __fastcall GetFixedRowHeight(void);
	void __fastcall SetWordWrap(bool value);
	void __fastcall SetSelectionColor(Graphics::TColor aColor);
	void __fastcall SetSelectionTextColor(Graphics::TColor aColor);
	void __fastcall SetSelectionRectangle(bool avalue);
	void __fastcall SetFilterActive(const bool Value);
	bool __fastcall MatchFilter(int arow);
	void __fastcall ApplyFilter(void);
	AnsiString __fastcall GetCellsEx(int i, int j);
	void __fastcall SetCellsEx(int i, int j, AnsiString value);
	System::TObject* __fastcall GetObjectsEx(int i, int j);
	void __fastcall SetObjectsEx(int i, int j, System::TObject* aObject);
	Graphics::TColor __fastcall GetColors(int i, int j);
	void __fastcall SetColors(int i, int j, Graphics::TColor aColor);
	AnsiString __fastcall GetStrippedCell(int i, int j);
	Classes::TStrings* __fastcall HiddenRow(int j);
	int __fastcall PasteText(int aCol, int aRow, char * p);
	void __fastcall InputFromCSV(AnsiString FileName, bool insertmode);
	void __fastcall OutputToCSV(AnsiString FileName, bool appendmode);
	void __fastcall LoadXLS(AnsiString filename, AnsiString sheetname);
	void __fastcall SaveXLS(AnsiString filename, AnsiString sheetname);
	Comctrls::TDateTimePicker* __fastcall GetDateTimePicker(void);
	void __fastcall SetArrowColor(Graphics::TColor value);
	Graphics::TColor __fastcall GetArrowColor(void);
	
public:
	bool lbutflg;
	int compares;
	int swaps;
	unsigned sorttime;
	Classes::TStringList* sortlist;
	int prevsizex;
	int prevsizey;
	bool editmode;
	void __fastcall ClearComboString(void);
	void __fastcall AddComboString(const AnsiString s);
	bool __fastcall RemoveComboString(const AnsiString s);
	bool __fastcall SetComboSelectionString(const AnsiString s);
	void __fastcall SetComboSelection(int idx);
	int __fastcall GetComboCount(void);
	__fastcall virtual TAdvStringGrid(Classes::TComponent* aOwner);
	__fastcall virtual ~TAdvStringGrid(void);
	virtual int __fastcall GetVersionNr(void);
	virtual AnsiString __fastcall GetVersionString();
	virtual bool __fastcall ValidateCell(const AnsiString s);
	virtual void __fastcall RemoveRowsEx(int RowIndex, int RCount);
	virtual void __fastcall RemoveRows(int RowIndex, int RCount);
	virtual void __fastcall InsertRows(int RowIndex, int RCount);
	virtual void __fastcall RemoveCols(int ColIndex, int CCount);
	virtual void __fastcall InsertCols(int ColIndex, int CCount);
	void __fastcall RemoveSelectedRows(void);
	void __fastcall MergeCols(int ColIndex1, int ColIndex2);
	void __fastcall SwapColumns(int aCol1, int aCol2);
	void __fastcall HideColumn(int colindex);
	void __fastcall UnhideColumn(int colindex);
	void __fastcall HideColumns(int fromcol, int tocol);
	void __fastcall UnhideColumns(int fromcol, int tocol);
	void __fastcall UnhideColumnsAll(void);
	bool __fastcall IsHiddenColumn(int colindex);
	int __fastcall NumHiddenColumns(void);
	void __fastcall RepaintRect(const Windows::TRect &r);
	void __fastcall RepaintCell(int c, int r);
	void __fastcall RepaintRow(int aRow);
	void __fastcall RepaintCol(int aCol);
	void __fastcall GroupCalc(int colindex, int method);
	void __fastcall GroupSum(int colindex);
	void __fastcall GroupAvg(int colindex);
	void __fastcall GroupMin(int colindex);
	void __fastcall GroupMax(int colindex);
	void __fastcall Group(int colindex);
	void __fastcall UnGroup(void);
	void __fastcall HideRow(int rowindex);
	void __fastcall HideRows(int fromrow, int torow);
	void __fastcall HideRowsEx(int fromrow, int torow);
	void __fastcall UnHideRow(int rowindex);
	void __fastcall UnHideRows(int fromrow, int torow);
	void __fastcall UnHideRowsAll(void);
	void __fastcall HideSelectedRows(void);
	bool __fastcall IsHiddenRow(int rowindex);
	int __fastcall NumHiddenRows(void);
	int __fastcall RealRowIndex(int arow);
	int __fastcall RealColIndex(int acol);
	int __fastcall DisplRowIndex(int arow);
	int __fastcall DisplColIndex(int acol);
	int __fastcall GetRealCol(void);
	int __fastcall GetRealRow(void);
	void __fastcall HideSelection(void);
	void __fastcall UnHideSelection(void);
	void __fastcall ScrollInView(int ColIndex, int RowIndex);
	HIDESBASE void __fastcall MoveRow(int FromIndex, int ToIndex);
	HIDESBASE void __fastcall MoveColumn(int FromIndex, int ToIndex);
	void __fastcall SwapRows(int aRow1, int aRow2);
	void __fastcall SortSwapRows(int aRow1, int aRow2);
	virtual void __fastcall ClearRect(int aCol1, int aRow1, int aCol2, int aRow2);
	void __fastcall Clear(void);
	void __fastcall ClearRows(int RowIndex, int RCount);
	void __fastcall ClearCols(int ColIndex, int CCount);
	void __fastcall ClearNormalCells(void);
	void __fastcall ClearRowSelect(void);
	void __fastcall SelectRows(int RowIndex, int RCount);
	void __fastcall SelectCols(int ColIndex, int CCount);
	void __fastcall SelectRange(int FromCol, int ToCol, int FromRow, int ToRow);
	bool __fastcall isCell(AnsiString SubStr, int &ACol, int &ARow);
	void __fastcall SaveToFile(AnsiString FileName);
	void __fastcall SaveToHTML(AnsiString FileName);
	void __fastcall SaveToXML(AnsiString FileName, AnsiString ListDescr, AnsiString RecordDescr, Classes::TStrings* 
		FieldDescr);
	void __fastcall SaveToASCII(AnsiString FileName);
	void __fastcall SaveToCSV(AnsiString fileName);
	void __fastcall AppendToCSV(AnsiString fileName);
	void __fastcall SaveToStream(Classes::TStream* stream);
	void __fastcall LoadFromFile(AnsiString FileName);
	void __fastcall LoadFromCSV(AnsiString FileName);
	void __fastcall LoadFromFixed(AnsiString FileName, Advobj::TIntList* positions);
	void __fastcall InsertFromCSV(AnsiString FileName);
	void __fastcall LoadFromStream(Classes::TStream* stream);
	void __fastcall SaveColSizes(void);
	void __fastcall LoadColSizes(void);
	void __fastcall SavePrintSettings(AnsiString key, AnsiString section);
	void __fastcall LoadPrintSettings(AnsiString key, AnsiString section);
	void __fastcall CutToClipboard(void);
	void __fastcall CutSelectionToClipboard(void);
	void __fastcall CopyToClipBoard(void);
	void __fastcall CopySelectionToClipboard(void);
	void __fastcall PasteFromClipboard(void);
	void __fastcall PasteSelectionFromClipboard(void);
	void __fastcall ShowColumnHeaders(void);
	void __fastcall ClearColumnHeaders(void);
	void __fastcall ShowRowHeaders(void);
	void __fastcall ClearRowHeaders(void);
	void __fastcall HideCellEdit(void);
	void __fastcall ShowCellEdit(void);
	void __fastcall RandomFill(bool doFixed, int rnd);
	void __fastcall Zoom(int x);
	void __fastcall SaveToXLS(AnsiString Filename);
	void __fastcall SaveTOXLSSheet(AnsiString Filename, AnsiString SheetName);
	void __fastcall LoadFromXLS(AnsiString Filename);
	void __fastcall LoadFromXLSSheet(AnsiString Filename, AnsiString SheetName);
	void __fastcall SaveToDOC(AnsiString Filename);
	void __fastcall RichToCell(int col, int row, Comctrls::TRichEdit* richeditor);
	void __fastcall CellToRich(int col, int row, Comctrls::TRichEdit* richeditor);
	void __fastcall AutoSizeCells(const bool DoFixedCells, const int PaddingX, const int PaddingY);
	void __fastcall AutoSizeColumns(const bool DoFixedCols, const int Padding);
	void __fastcall AutoSizeCol(const int aCol);
	void __fastcall AutoSizeRows(const bool DoFixedRows, const int Padding);
	void __fastcall AutoSizeRow(const int aRow);
	void __fastcall StretchRightColumn(void);
	void __fastcall AutoNumberCol(const int aCol);
	bool __fastcall IsSelected(int aCol, int aRow);
	AnsiString __fastcall SelectedText();
	void __fastcall ShowInplaceEdit(void);
	void __fastcall HideInplaceEdit(void);
	void __fastcall QSort(void);
	void __fastcall QSortIndexed(void);
	void __fastcall QSortGroup(void);
	void __fastcall Print(void);
	void __fastcall PrintRect(const Grids::TGridRect &gridrect);
	void __fastcall PrintPreview(Graphics::TCanvas* Canvas, const Windows::TRect &displayrect);
	void __fastcall PrintPreviewRect(Graphics::TCanvas* Canvas, const Windows::TRect &displayrect, const 
		Grids::TGridRect &gridrect);
	void __fastcall PrintDraw(Graphics::TCanvas* Canvas, const Windows::TRect &DrawRect);
	void __fastcall PrintDrawRect(Graphics::TCanvas* Canvas, const Windows::TRect &DrawRect, const Grids::TGridRect 
		&gridrect);
	void __fastcall SortByColumn(int col);
	void __fastcall QuickSort(int col, int left, int right);
	void __fastcall QuickSortIndexed(int left, int right);
	bool __fastcall SortLine(int col, int arow1, int arow2);
	int __fastcall Search(AnsiString s);
	Windows::TPoint __fastcall FindFirst(AnsiString s, TFindParams findparams);
	Windows::TPoint __fastcall FindNext();
	int __fastcall MapFontHeight(int pointsize);
	int __fastcall MapFontSize(int height);
	Graphics::TBitmap* __fastcall CreateBitmap(int aCol, int aRow, bool transparent, TCellHAlign hal, TCellVAlign 
		val);
	void __fastcall AddBitmap(int aCol, int aRow, Graphics::TBitmap* abmp, bool transparent, TCellHAlign 
		hal, TCellVAlign val);
	void __fastcall RemoveBitmap(int aCol, int aRow);
	Graphics::TBitmap* __fastcall GetBitmap(int aCol, int aRow);
	Graphics::TPicture* __fastcall CreatePicture(int aCol, int aRow, bool transparent, TStretchMode stretchmode
		, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall AddPicture(int aCol, int aRow, Graphics::TPicture* apicture, bool transparent, TStretchMode 
		stretchmode, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemovePicture(int aCol, int aRow);
	Graphics::TPicture* __fastcall GetPicture(int aCol, int aRow);
	Advobj::TFilePicture* __fastcall CreateFilePicture(int aCol, int aRow, bool transparent, TStretchMode 
		stretchmode, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall AddFilePicture(int aCol, int aRow, Advobj::TFilePicture* afilepicture, bool transparent
		, TStretchMode stretchmode, int padding, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveFilePicture(int aCol, int aRow);
	Advobj::TFilePicture* __fastcall GetFilePicture(int aCol, int aRow);
	void __fastcall AddNode(int aRow, int Span);
	void __fastcall RemoveNode(int aRow);
	bool __fastcall IsNode(int aRow);
	bool __fastcall GetNodeState(int ARow);
	void __fastcall SetNodeState(int ARow, bool value);
	void __fastcall ExpandNode(int aRow);
	void __fastcall ContractNode(int aRow);
	void __fastcall ExpandAll(void);
	void __fastcall ContractAll(void);
	void __fastcall AddRadio(int aCol, int aRow, int DirRadio, int IdxRadio, Classes::TStrings* sl);
	void __fastcall RemoveRadio(int aCol, int aRow);
	bool __fastcall IsRadio(int Acol, int Arow);
	bool __fastcall GetRadioIdx(int Acol, int Arow, int &IdxRadio);
	bool __fastcall SetRadioIdx(int Acol, int Arow, int IdxRadio);
	void __fastcall AddImageIdx(int Acol, int Arow, int Aidx, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveImageIdx(int Acol, int Arow);
	bool __fastcall GetImageIdx(int Acol, int Arow, int &idx);
	void __fastcall AddMultiImage(int Acol, int Arow, int Dir, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveMultiImage(int Acol, int Arow);
	void __fastcall AddDataImage(int Acol, int Arow, int Aidx, TCellHAlign hal, TCellVAlign val);
	void __fastcall RemoveDataImage(int Acol, int Arow);
	void __fastcall AddRotated(int Acol, int Arow, short aAngle, AnsiString s);
	void __fastcall RemoveRotated(int Acol, int Arow);
	bool __fastcall IsRotated(int Acol, int Arow, int &aAngle);
	Graphics::TIcon* __fastcall CreateIcon(int Acol, int Arow, TCellHAlign hal, TCellVAlign val);
	void __fastcall AddIcon(int Acol, int Arow, Graphics::TIcon* aicon, TCellHAlign hal, TCellVAlign val
		);
	void __fastcall RemoveIcon(int Acol, int Arow);
	void __fastcall AddButton(int Acol, int Arow, int bw, int bh, AnsiString caption, TCellHAlign hal, 
		TCellVAlign val);
	void __fastcall PushButton(int Acol, int Arow, bool push);
	void __fastcall RemoveButton(int Acol, int Arow);
	bool __fastcall HasButton(int Acol, int Arow);
	void __fastcall AddCheckBox(int Acol, int Arow, bool state, bool data);
	void __fastcall RemoveCheckBox(int Acol, int Arow);
	bool __fastcall HasCheckBox(int Acol, int Arow);
	bool __fastcall GetCheckBoxState(int Acol, int Arow, bool &state);
	bool __fastcall SetCheckBoxState(int Acol, int Arow, bool state);
	bool __fastcall ToggleCheckBox(int Acol, int Arow);
	void __fastcall AddProgress(int Acol, int Arow, Graphics::TColor FGColor, Graphics::TColor BKColor)
		;
	void __fastcall RemoveProgress(int Acol, int Arow);
	void __fastcall AddComment(int Acol, int Arow, AnsiString comment);
	void __fastcall RemoveComment(int Acol, int Arow);
	bool __fastcall IsComment(int Acol, int Arow, AnsiString &comment);
	double __fastcall ColumnSum(int acol, int fromrow, int torow);
	double __fastcall ColumnAvg(int acol, int fromrow, int torow);
	double __fastcall ColumnMin(int acol, int fromrow, int torow);
	double __fastcall ColumnMax(int acol, int fromrow, int torow);
	double __fastcall RowSum(int arow, int fromcol, int tocol);
	double __fastcall RowAvg(int arow, int fromcol, int tocol);
	double __fastcall RowMin(int arow, int fromcol, int tocol);
	double __fastcall RowMax(int arow, int fromcol, int tocol);
	void __fastcall BeginUpdate(void);
	void __fastcall EndUpdate(void);
	void __fastcall ResetUpdate(void);
	__property bool LockUpdate = {read=GetLockFlag, write=SetLockFlag, nodefault};
	__property TCellType CellTypes[int ACol][int Arow] = {read=GetCellType};
	__property TCellGraphic* CellGraphics[int Acol][int Arow] = {read=GetCellGraphic};
	__property Windows::TPoint CellGraphicSize[int Acol][int Arow] = {read=GetCellGraphicSize};
	__property Advobj::TIntList* CellImages[int Acol][int Arow] = {read=GetCellImages};
	__property int Ints[int ACol][int ARow] = {read=GetInts, write=SetInts};
	__property double Floats[int ACol][int ARow] = {read=GetFloats, write=SetFloats};
	__property System::TDateTime Dates[int ACol][int ARow] = {read=GetDates, write=SetDates};
	__property System::TDateTime Times[int ACol][int ARow] = {read=GetTimes, write=SetTimes};
	__property char Delimiter = {read=FDelimiter, write=FDelimiter, nodefault};
	__property char PasswordChar = {read=FPasswordChar, write=FPasswordChar, nodefault};
	__property bool JavaCSV = {read=FJavaCSV, write=FJavaCSV, nodefault};
	__property bool FastPrint = {read=FFastPrint, write=FFastPrint, nodefault};
	__property AnsiString CheckTrue = {read=FCheckTrue, write=FCheckTrue};
	__property AnsiString CheckFalse = {read=FCheckFalse, write=FCheckFalse};
	__property bool SaveFixedCells = {read=FSaveFixedCells, write=FSaveFixedCells, nodefault};
	__property bool SaveHiddenCells = {read=FSaveHiddenCells, write=FSaveHiddenCells, nodefault};
	__property Advobj::TSortIndexList* SortIndexes = {read=FSortIndexes};
	__property AnsiString OriginalCellValue = {read=cellcache};
	__property Comctrls::TDateTimePicker* DateTimePicker = {read=GetDateTimePicker};
	__property TGridCombo* Combobox = {read=editcombo};
	__property TGridSpin* SpinEdit = {read=editspin};
	__property TGridEditBtn* BtnEdit = {read=editbtn};
	__property TGridUnitEditBtn* BtnUnitEdit = {read=uniteditbtn};
	__property TAdvRichEdit* RichEdit = {read=FRichEdit};
	__property TAdvInplaceEdit* NormalEdit = {read=GetInplaceEditor};
	__property bool PrinterDriverFix = {read=fprinterdriverfix, write=fprinterdriverfix, nodefault};
	__property bool RowSelect[int aRow] = {read=GetRowSelect, write=SetRowSelect};
	__property int RowSelectCount = {read=GetRowSelectCount, nodefault};
	__property bool NodeState[int aRow] = {read=GetNodeState, write=SetNodeState};
	__property bool FindBusy = {read=fFindBusy, nodefault};
	__property Windows::TRect PrintPageRect = {read=fprintpagerect};
	__property int PrintPageWidth = {read=fprintpagewidth, nodefault};
	__property int PrintColWidth[int aCol] = {read=GetPrintColWidth};
	__property int PrintColOffset[int aCol] = {read=GetPrintColOffset};
	__property int PrintColStart = {read=fprintcolstart, nodefault};
	__property int PrintColEnd = {read=fprintcolend, nodefault};
	__property int PrintNrOfPages = {read=fprintpagenum, nodefault};
	__property bool ExcelClipboardFormat = {read=fExcelClipboardFormat, write=fExcelClipboardFormat, nodefault
		};
	__property int PreviewPage = {read=fprintpagefrom, write=SetPreviewPage, nodefault};
	__property AnsiString AllCells[int i][int j] = {read=GetCellsEx, write=SetCellsEx};
	__property System::TObject* AllObjects[int i][int j] = {read=GetObjectsEx, write=SetObjectsEx};
	__property Graphics::TColor Colors[int i][int j] = {read=GetColors, write=SetColors};
	__property AnsiString StrippedCells[int i][int j] = {read=GetStrippedCell};
	__property Graphics::TColor ArrowColor = {read=GetArrowColor, write=SetArrowColor, nodefault};
	__property int GroupColumn = {read=FGroupColumn, write=SetGroupColumn, nodefault};
	__property int RealRow = {read=GetRealRow, nodefault};
	__property int RealCol = {read=GetRealCol, nodefault};
	__property int VersionNr = {read=GetVersionNr, nodefault};
	__property AnsiString VersionString = {read=GetVersionString};
	__property TEditLink* EditLink = {read=fEditLink, write=fEditLink};
	
protected:
	Windows::TPoint fcliptopleft;
	TClipOperation fcliplastop;
	virtual void __fastcall DrawCell(int ACol, int ARow, const Windows::TRect &ARect, Grids::TGridDrawState 
		AState);
	virtual void __fastcall PasteNotify(const Windows::TPoint &orig, const Grids::TGridRect &gr, TClipOperation 
		lastop);
	virtual AnsiString __fastcall CalcCell(int ACol, int ARow);
	virtual void __fastcall UpdateCell(int ACol, int ARow);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	virtual Grids::TInplaceEdit* __fastcall CreateEditor(void);
	virtual bool __fastcall CanEditShow(void);
	DYNAMIC void __fastcall SetEditText(int ACol, int ARow, const AnsiString Value);
	DYNAMIC AnsiString __fastcall GetEditText(int ACol, int ARow);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall ColumnMoved(int FromIndex, int ToIndex);
	DYNAMIC void __fastcall RowMoved(int FromIndex, int ToIndex);
	DYNAMIC void __fastcall KeyPress(char &Key);
	virtual void __fastcall DestroyWnd(void);
	virtual void __fastcall CreateWnd(void);
	virtual void __fastcall Loaded(void);
	virtual bool __fastcall SelectCell(int ACol, int ARow);
	virtual void __fastcall WndProc(Messages::TMessage &Message);
	DYNAMIC void __fastcall SizeChanged(int OldColCount, int OldRowCount);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation AOperation
		);
	virtual void __fastcall CalcSizingState(int X, int Y, Grids::TGridState &State, int &Index, int &SizingPos
		, int &SizingOfs, Grids::TGridDrawInfo &FixedInfo);
	DYNAMIC void __fastcall Click(void);
	DYNAMIC void __fastcall DoEnter(void);
	DYNAMIC void __fastcall DoExit(void);
	virtual void __fastcall InitValidate(int acol, int arow);
	virtual void __fastcall Paint(void);
	DYNAMIC void __fastcall ColWidthsChanged(void);
	DYNAMIC void __fastcall RowHeightsChanged(void);
	void __fastcall InvalidateGridRect(const Grids::TGridRect &r);
	DYNAMIC void __fastcall TopLeftChanged(void);
	virtual AnsiString __fastcall EllipsClick(AnsiString s);
	virtual void __fastcall GetCellColor(int ACol, int ARow, Grids::TGridDrawState AState, Graphics::TBrush* 
		ABrush, Graphics::TFont* AFont);
	virtual void __fastcall GetCellPrintColor(int ACol, int ARow, Grids::TGridDrawState AState, Graphics::TBrush* 
		ABrush, Graphics::TFont* AFont);
	virtual void __fastcall GetCellBorder(int ACol, int ARow, Graphics::TPen* APen, TCellBorders &borders
		);
	virtual void __fastcall GetCellPrintBorder(int ACol, int ARow, Graphics::TPen* APen, TCellBorders &
		borders);
	virtual void __fastcall GetCellAlign(int ACol, int ARow, Classes::TAlignment &AAlignment);
	virtual void __fastcall GetColFormat(int ACol, TSortStyle &AStyle, AnsiString &aPrefix, AnsiString 
		&aSuffix);
	virtual void __fastcall GetCellEditor(int ACol, int ARow, TEditorType &AEditor);
	virtual void __fastcall GetCellFixed(int ACol, int ARow, bool &IsFixed);
	virtual void __fastcall GetCellReadOnly(int ACol, int ARow, bool &IsReadOnly);
	virtual void __fastcall GetCellPassword(int ACol, int ARow, bool &IsPassword);
	
__published:
	__property TBands* Bands = {read=FBands, write=FBands};
	__property bool AutoNumAlign = {read=FAutoNumAlign, write=FAutoNumAlign, nodefault};
	__property bool AutoSize = {read=FAutoSize, write=SetAutoSize, nodefault};
	__property TVAlignment VAlignment = {read=FVAlignment, write=SetVAlignment, nodefault};
	__property bool EnhTextSize = {read=FEnhTextSize, write=FEnhTextSize, nodefault};
	__property bool EnhRowColMove = {read=FEnhRowColMove, write=FEnhRowColMove, nodefault};
	__property bool SortFixedCols = {read=FSortFixedCols, write=FSortFixedCols, nodefault};
	__property bool SortNormalCellsOnly = {read=FSortNormalCellsOnly, write=FSortNormalCellsOnly, nodefault
		};
	__property bool SizeWithForm = {read=FSizeWithForm, write=FSizeWithForm, nodefault};
	__property bool Multilinecells = {read=FMultilinecells, write=FMultilinecells, nodefault};
	__property TGridColorEvent OnGetCellColor = {read=FOnGetCellColor, write=FOnGetCellColor};
	__property TGridColorEvent OnGetCellPrintColor = {read=FOnGetCellPrintColor, write=FOnGetCellPrintColor
		};
	__property TGridBorderEvent OnGetCellPrintBorder = {read=FOnGetCellPrintBorder, write=FOnGetCellPrintBorder
		};
	__property TGridBorderEvent OnGetCellBorder = {read=FOnGetCellBorder, write=FOnGetCellBorder};
	__property TGridAlignEvent OnGetAlignment = {read=FOnGetAlignment, write=FOnGetAlignment};
	__property TGridFormatEvent OnGetFormat = {read=FOnGetFormat, write=FOnGetFormat};
	__property TGridHintEvent OnGridHint = {read=FOnGridHint, write=FOnGridHint};
	__property TRowChangingEvent OnRowChanging = {read=FOnRowChanging, write=FOnRowChanging};
	__property TColChangingEvent OnColChanging = {read=FOnColChanging, write=FOnColChanging};
	__property TCellChangingEvent OnCellChanging = {read=FOnCellChanging, write=FOnCellChanging};
	__property TGridPrintPageEvent OnPrintPage = {read=FOnPrintPage, write=FOnPrintPage};
	__property TGridPrintStartEvent OnPrintStart = {read=FOnPrintStart, write=FOnPrintStart};
	__property TDoFitToPageEvent OnFitToPage = {read=FDoFitToPage, write=FDoFitToPage};
	__property TGridPrintNewPageEvent OnPrintNewPage = {read=FOnPrintNewPage, write=FOnPrintNewPage};
	__property TGridPrintColumnWidthEvent OnPrintSetColumnWidth = {read=FOnPrintSetColumnWidth, write=FOnPrintSetColumnWidth
		};
	__property TGridPrintRowHeightEvent OnPrintSetRowHeight = {read=FOnPrintSetRowHeight, write=FOnPrintSetRowHeight
		};
	__property TCanAddRowEvent OnCanAddRow = {read=FOnCanAddRow, write=FOnCanAddRow};
	__property TAutoAddRowEvent OnAutoAddRow = {read=FOnAutoAddRow, write=FOnAutoAddRow};
	__property TCanInsertRowEvent OnCanInsertRow = {read=FOnCanInsertRow, write=FOnCanInsertRow};
	__property TAutoInsertRowEvent OnAutoInsertRow = {read=FOnAutoInsertRow, write=FOnAutoInsertRow};
	__property TAutoInsertColEvent OnAutoInsertCol = {read=FOnAutoInsertCol, write=FOnAutoInsertCol};
	__property TCanDeleteRowEvent OnCanDeleteRow = {read=FOnCanDeleteRow, write=FOnCanDeleteRow};
	__property TAutoDeleteRowEvent OnAutoDeleteRow = {read=FOnAutoDeleteRow, write=FOnAutoDeleteRow};
	__property TClickSortEvent OnClickSort = {read=FOnClickSort, write=FOnClickSort};
	__property TCanSortEvent OnCanSort = {read=FOnCanSort, write=FOnCanSort};
	__property TNodeClickEvent OnExpandNode = {read=FOnExpandNode, write=FOnExpandNode};
	__property TNodeClickEvent OnContractNode = {read=FOnContractNode, write=FOnContractNode};
	__property TCustomCompareEvent OnCustomCompare = {read=FCustomCompare, write=FCustomCompare};
	__property TRawCompareEvent OnRawCompare = {read=FRawCompare, write=FRawCompare};
	__property TClickCellEvent OnClickCell = {read=FOnClickCell, write=FOnClickCell};
	__property TClickCellEvent OnRightClickCell = {read=FOnRightClickCell, write=FOnRightClickCell};
	__property TDblClickCellEvent OnDblClickCell = {read=FOnDblClickCell, write=FOnDblClickCell};
	__property TCanEditCellEvent OnCanEditCell = {read=FOnCanEditCell, write=FOnCanEditCell};
	__property TIsFixedCellEvent OnIsFixedCell = {read=FOnIsFixedCell, write=FOnIsFixedCell};
	__property TIsPasswordCellEvent OnIsPasswordCell = {read=FOnIsPasswordCell, write=FOnIsPasswordCell
		};
	__property TAnchorClickEvent OnAnchorClick = {read=FOnAnchorClick, write=FOnAnchorClick};
	__property TAnchorEvent OnAnchorEnter = {read=FOnAnchorEnter, write=FOnAnchorEnter};
	__property TAnchorEvent OnAnchorExit = {read=FOnAnchorExit, write=FOnAnchorExit};
	__property TClipboardEvent OnClipboardPaste = {read=FOnClipboardPaste, write=FOnClipboardPaste};
	__property TClipboardEvent OnClipboardCopy = {read=FonClipboardCopy, write=FonClipboardCopy};
	__property TClipboardEvent OnClipboardCut = {read=FOnClipboardCut, write=FOnClipboardCut};
	__property TCellValidateEvent OnCellValidate = {read=FOnCellValidate, write=FOnCellValidate};
	__property TGridProgressEvent OnFileProgress = {read=FOnFileProgress, write=FOnFileProgress};
	__property TSortDirection SortDirection = {read=FSortDirection, write=FSortDirection, nodefault};
	__property TGetEditorTypeEvent OnGetEditorType = {read=FOnGetEditorType, write=FOnGetEditorType};
	__property TGetEditorPropEvent OnGetEditorProp = {read=FOnGetEditorProp, write=FOnGetEditorProp};
	__property TEllipsClickEvent OnEllipsClick = {read=FOnEllipsClick, write=FOnEllipsClick};
	__property TButtonClickEvent OnButtonClick = {read=FOnButtonClick, write=FOnButtonClick};
	__property TCheckBoxClickEvent OnCheckBoxClick = {read=FOnCheckBoxClick, write=FOnCheckBoxClick};
	__property TCheckBoxClickEvent OnCheckBoxMouseUp = {read=FOnCheckBoxMouseUp, write=FOnCheckBoxMouseUp
		};
	__property TRadioClickEvent OnRadioClick = {read=FOnRadioClick, write=FOnRadioClick};
	__property TRadioClickEvent OnRadioMouseUp = {read=FOnRadioMouseUp, write=FOnRadioMouseUp};
	__property TComboChangeEvent OnComboChange = {read=FOnComboChange, write=FOnComboChange};
	__property TSpinClickEvent OnSpinClick = {read=FOnSpinClick, write=FOnSpinClick};
	__property TFloatSpinClickEvent OnFloatSpinClick = {read=FOnFloatSpinClick, write=FOnFloatSpinClick
		};
	__property TDateTimeSpinClickEvent OnTimeSpinClick = {read=FOnTimeSpinClick, write=FOnTimeSpinClick
		};
	__property TDateTimeSpinClickEvent OnDateSpinClick = {read=FOnDateSpinClick, write=FOnDateSpinClick
		};
	__property TOleDragDropEvent OnOleDrop = {read=FOnOleDrop, write=FOnOleDrop};
	__property TOleDragDropEvent OnOleDrag = {read=FOnOleDrag, write=FOnOleDrag};
	__property bool SortFull = {read=FSortFull, write=FSortFull, nodefault};
	__property bool SortAutoFormat = {read=FSortAutoFormat, write=FSortAutoFormat, nodefault};
	__property bool SortShow = {read=FSortShow, write=SetSortShow, nodefault};
	__property bool SortIndexShow = {read=FSortIndexShow, write=SetSortIndexShow, nodefault};
	__property bool EnableGraphics = {read=FEnableGraphics, write=FEnableGraphics, nodefault};
	__property bool EnableHTML = {read=FEnableHTML, write=FEnableHTML, nodefault};
	__property int SortColumn = {read=FSortColumn, write=SetSortColumn, nodefault};
	__property Graphics::TColor HintColor = {read=FHintColor, write=FHintColor, nodefault};
	__property Graphics::TColor SelectionColor = {read=FSelectionColor, write=SetSelectionColor, nodefault
		};
	__property Graphics::TColor SelectionTextColor = {read=FSelectionTextColor, write=SetSelectionTextColor
		, nodefault};
	__property bool SelectionRectangle = {read=FSelectionRectangle, write=SetSelectionRectangle, nodefault
		};
	__property bool SelectionRTFKeep = {read=FSelectionRTFKeep, write=FSelectionRTFKeep, nodefault};
	__property bool HintShowCells = {read=FHintShowCells, write=FHintShowCells, nodefault};
	__property bool HintShowLargeText = {read=FHintShowLargeText, write=FHintShowLargeText, nodefault};
		
	__property TScrollHintEvent OnScrollHint = {read=FOnScrollHint, write=FOnScrollHint};
	__property TColumnSizeEvent OnColumnSize = {read=FOnColumnSize, write=FOnColumnSize};
	__property TEndColumnSizeEvent OnEndColumnSize = {read=FOnEndColumnSize, write=FOnEndColumnSize};
	__property TEndRowSizeEvent OnEndRowSize = {read=FOnEndRowSize, write=FOnEndRowSize};
	__property TPrintsettings* PrintSettings = {read=FPrintSettings, write=FPrintSettings};
	__property THTMLSettings* HTMLSettings = {read=FHTMLSettings, write=FHTMLSettings};
	__property TNavigation* Navigation = {read=FNavigation, write=FNavigation};
	__property TColumnSize* ColumnSize = {read=FColumnSize, write=FColumnSize};
	__property TCellNode* CellNode = {read=FCellNode, write=FCellNode};
	__property TSizeWhileTyping* SizeWhileTyping = {read=FSizeWhileTyping, write=FSizeWhileTyping};
	__property int MaxEditLength = {read=fMaxEditLength, write=SetMaxEditLength, nodefault};
	__property TMouseActions* MouseActions = {read=FMouseActions, write=FMouseActions};
	__property Controls::TImageList* GridImages = {read=FGridImages, write=SetImages};
	__property TIntelliPan IntelliPan = {read=FIntelliPan, write=FIntelliPan, nodefault};
	__property Graphics::TColor URLColor = {read=FURLColor, write=SetURLColor, nodefault};
	__property bool URLShow = {read=FURLShow, write=SetURLShow, nodefault};
	__property bool URLFull = {read=FURLFull, write=SetURLFull, nodefault};
	__property bool URLEdit = {read=FURLEdit, write=FURLEdit, nodefault};
	__property TScrollType ScrollType = {read=FScrollType, write=SetScrollType, nodefault};
	__property Graphics::TColor ScrollColor = {read=FScrollColor, write=SetScrollColor, nodefault};
	__property int ScrollWidth = {read=FScrollWidth, write=SetScrollWidth, nodefault};
	__property bool ScrollSynch = {read=FScrollSynch, write=FScrollSynch, nodefault};
	__property bool ScrollProportional = {read=FScrollProportional, write=SetScrollProportional, nodefault
		};
	__property TScrollHintType ScrollHints = {read=FScrollHints, write=FScrollHints, nodefault};
	__property bool OemConvert = {read=FOemConvert, write=FOemConvert, nodefault};
	__property int FixedFooters = {read=FFixedFooters, write=SetFixedFooters, nodefault};
	__property int FixedRightCols = {read=FFixedRightCols, write=SetFixedRightCols, nodefault};
	__property int FixedColWidth = {read=GetFixedColWidth, write=SetFixedColWidth, nodefault};
	__property int FixedRowHeight = {read=GetFixedRowHeight, write=SetFixedRowHeight, nodefault};
	__property Graphics::TFont* FixedFont = {read=FFixedFont, write=SetFixedFont};
	__property bool FixedAsButtons = {read=FFixedAsButtons, write=FFixedAsButtons, nodefault};
	__property AnsiString FloatFormat = {read=FFloatFormat, write=FFloatFormat};
	__property bool WordWrap = {read=FWordWrap, write=SetWordWrap, nodefault};
	__property Classes::TStringList* ColumnHeaders = {read=FColumnHeaders, write=SetColumnHeaders};
	__property Classes::TStringList* RowHeaders = {read=FRowHeaders, write=SetRowHeaders};
	__property Classes::TStringList* LookupItems = {read=FLookupItems, write=SetLookupItems};
	__property bool Lookup = {read=FLookup, write=FLookup, nodefault};
	__property bool LookupCaseSensitive = {read=FLookupCaseSensitive, write=FLookupCaseSensitive, nodefault
		};
	__property bool LookupHistory = {read=FLookupHistory, write=FLookupHistory, nodefault};
	__property bool ShowSelection = {read=FShowSelection, write=SetShowSelection, default=1};
	__property bool HideFocusRect = {read=FHideFocusRect, write=FHideFocusRect, nodefault};
	__property Graphics::TBitmap* SortUpGlyph = {read=GetUpGlyph, write=SetUpGlyph};
	__property Graphics::TBitmap* SortDownGlyph = {read=GetDownGlyph, write=SetDownGlyph};
	__property TBackGround* BackGround = {read=FBackGround, write=SetBackground};
	__property bool Hovering = {read=FHovering, write=SetHovering, nodefault};
	__property TFilter* Filter = {read=ffilter, write=ffilter};
	__property bool FilterActive = {read=ffilterActive, write=SetFilterActive, nodefault};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TAdvStringGrid(HWND ParentWindow) : Grids::TStringGrid(
		ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TBands : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool fPrint;
	bool fActive;
	int fTotalLength;
	int fSecondaryLength;
	int fPrimaryLength;
	Graphics::TColor fSecondaryColor;
	Graphics::TColor fPrimaryColor;
	TAdvStringGrid* fOwner;
	void __fastcall SetActive(const bool Value);
	void __fastcall SetPrimaryColor(const Graphics::TColor Value);
	void __fastcall SetPrimaryLength(const int Value);
	void __fastcall SetSecondaryColor(const Graphics::TColor Value);
	void __fastcall SetSecondaryLength(const int Value);
	
public:
	__fastcall TBands(TAdvStringGrid* aOwner);
	
__published:
	__property bool Active = {read=fActive, write=SetActive, nodefault};
	__property Graphics::TColor PrimaryColor = {read=fPrimaryColor, write=SetPrimaryColor, nodefault};
	__property int PrimaryLength = {read=fPrimaryLength, write=SetPrimaryLength, nodefault};
	__property Graphics::TColor SecondaryColor = {read=fSecondaryColor, write=SetSecondaryColor, nodefault
		};
	__property int SecondaryLength = {read=fSecondaryLength, write=SetSecondaryLength, nodefault};
	__property bool Print = {read=fPrint, write=fPrint, nodefault};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TBands(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TEditStyle { esInplace, esPopup };
#pragma option pop

class PASCALIMPLEMENTATION TEditLink : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TAdvStringGrid* fOwner;
	bool fWantKeyLeftRight;
	bool fWantKeyUpDown;
	bool fWantKeyHomeEnd;
	bool fWantKeyPriorNext;
	bool fWantKeyReturn;
	bool fWantKeyEscape;
	TEditStyle fEditStyle;
	Forms::TForm* fPopupForm;
	int fPopupWidth;
	int fPopupHeight;
	bool fForcedExit;
	Windows::TPoint fEditCell;
	int fTag;
	
public:
	__fastcall virtual TEditLink(Classes::TComponent* aOwner);
	__fastcall virtual ~TEditLink(void);
	virtual void __fastcall EditKeyDown(System::TObject* Sender, Word &Key, Classes::TShiftState Shift)
		;
	void __fastcall EditExit(System::TObject* Sender);
	void __fastcall FormExit(System::TObject* Sender);
	Controls::TWinControl* __fastcall GetParent(void);
	virtual Controls::TWinControl* __fastcall GetEditControl(void);
	AnsiString __fastcall GetCellValue();
	void __fastcall SetCellValue(AnsiString s);
	virtual void __fastcall CreateEditor(Controls::TWinControl* aParent);
	virtual void __fastcall DestroyEditor(void);
	void __fastcall HideEditor(void);
	virtual void __fastcall SetFocus(bool value);
	virtual void __fastcall SetRect(const Windows::TRect &r);
	virtual void __fastcall SetVisible(bool value);
	virtual void __fastcall SetProperties(void);
	virtual AnsiString __fastcall GetEditorValue();
	virtual void __fastcall SetEditorValue(AnsiString s);
	__property TAdvStringGrid* Grid = {read=fOwner};
	__property Windows::TPoint EditCell = {read=fEditCell};
	
__published:
	__property TEditStyle EditStyle = {read=fEditStyle, write=fEditStyle, nodefault};
	__property int PopupWidth = {read=fPopupWidth, write=fPopupWidth, nodefault};
	__property int PopupHeight = {read=fPopupHeight, write=fPopupHeight, nodefault};
	__property bool WantKeyLeftRight = {read=fWantKeyLeftRight, write=fWantKeyLeftRight, nodefault};
	__property bool WantKeyUpDown = {read=fWantKeyUpDown, write=fWantKeyUpDown, nodefault};
	__property bool WantKeyHomeEnd = {read=fWantKeyHomeEnd, write=fWantKeyHomeEnd, nodefault};
	__property bool WantKeyPriorNext = {read=fWantKeyPriorNext, write=fWantKeyPriorNext, nodefault};
	__property bool WantKeyReturn = {read=fWantKeyReturn, write=fWantKeyReturn, nodefault};
	__property bool WantKeyEscape = {read=fWantKeyEscape, write=fWantKeyEscape, nodefault};
	__property int Tag = {read=fTag, write=fTag, nodefault};
};


class PASCALIMPLEMENTATION TAdvInplaceEdit : public Grids::TInplaceEdit 
{
	typedef Grids::TInplaceEdit inherited;
	
private:
	short fLengthLimit;
	bool fvalign;
	bool fwordwrap;
	bool gotkey;
	bool workmode;
	TAdvStringGrid* fGrid;
	void __fastcall setvalign(bool value);
	void __fastcall setwordwrap(bool value);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKillFocus(Messages::TWMKillFocus &Msg);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &Msg);
	HIDESBASE MESSAGE void __fastcall WMPaste(Messages::TMessage &Msg);
	MESSAGE void __fastcall WMCopy(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall WMCut(Messages::TMessage &Msg);
	HIDESBASE MESSAGE void __fastcall CMWantSpecialKey(Messages::TWMKey &Msg);
	
public:
	void __fastcall DoChange(void);
	
protected:
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	virtual void __fastcall CreateWnd(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyUp(Word &Key, Classes::TShiftState Shift);
	DYNAMIC void __fastcall KeyPress(char &Key);
	virtual void __fastcall UpdateContents(void);
	
__published:
	__property bool valign = {read=fvalign, write=setvalign, nodefault};
	__property bool wordwrap = {read=fwordwrap, write=setwordwrap, nodefault};
	__property short LengthLimit = {read=fLengthLimit, write=fLengthLimit, nodefault};
public:
	#pragma option push -w-inl
	/* TInplaceEdit.Create */ inline __fastcall virtual TAdvInplaceEdit(Classes::TComponent* AOwner) : 
		Grids::TInplaceEdit(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TAdvInplaceEdit(HWND ParentWindow) : Grids::TInplaceEdit(
		ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~TAdvInplaceEdit(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TFilterData : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	short fColumn;
	AnsiString fCondition;
	
__published:
	__property short Column = {read=fColumn, write=fColumn, nodefault};
	__property AnsiString Condition = {read=fCondition, write=fCondition};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TFilterData(Classes::TCollection* Collection
		) : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TFilterData(void) { }
	#pragma option pop
	
};


class DELPHICLASS TGridItem;
class PASCALIMPLEMENTATION TGridItem : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int fIdx;
	Classes::TStrings* fItems;
	void __fastcall SetIdx(const int Value);
	void __fastcall SetItems(const Classes::TStrings* Value);
	
public:
	__fastcall virtual TGridItem(Classes::TCollection* Collection);
	__fastcall virtual ~TGridItem(void);
	
__published:
	__property int Idx = {read=fIdx, write=SetIdx, nodefault};
	__property Classes::TStrings* Items = {read=fItems, write=SetItems};
};


//-- var, const, procedure ---------------------------------------------------
static const Word MAXCOLUMNS = 0x100;
static const Shortint CHECKBOXSIZE = 0xf;

}	/* namespace Advgrid */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Advgrid;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// AdvGrid
